/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.handler;

import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.registry.LunarRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.apache.commons.lang3.tuple.Pair;

public class LunarHandler {
    public static void onOverworldTick(class_1937 level) {
        block7: {
            ILunarEvent event;
            LunarPhaseData phaseData;
            class_3218 serverLevel;
            block8: {
                block9: {
                    if (level.method_8510() % 20L != 0L || !(level instanceof class_3218)) break block7;
                    serverLevel = (class_3218)level;
                    phaseData = LunarPhaseData.get((class_1937)serverLevel);
                    event = phaseData.getActiveLunarEvent();
                    int currentTime = (int)(serverLevel.method_8532() % 24000L);
                    if (currentTime <= 13000 || currentTime >= 23000) break block8;
                    if (phaseData.hasEventActive()) break block9;
                    phaseData.setRandomLunarEvent((class_1937)serverLevel);
                    phaseData.syncEvent((class_1937)serverLevel);
                    break block7;
                }
                if (event == null) break block7;
                if (event.applyEntityEffect()) {
                    serverLevel.method_27909().forEach(entity -> {
                        if (entity.method_7325()) {
                            return;
                        }
                        event.applyEntityEffect((class_1297)entity);
                    });
                }
                if (!event.applyPlayerEffect()) break block7;
                serverLevel.method_18456().forEach(event::applyPlayerEffect);
                break block7;
            }
            if (phaseData.hasEventActive()) {
                if (event != null) {
                    if (event.applyEntityEffect()) {
                        serverLevel.method_27909().forEach(entity -> {
                            if (entity.method_7325()) {
                                return;
                            }
                            event.removeEntityEffect((class_1297)entity);
                        });
                    }
                    if (event.applyPlayerEffect()) {
                        serverLevel.method_18456().forEach(event::removePlayerEffect);
                    }
                }
                phaseData.eraseEvent();
                phaseData.syncEvent((class_1937)serverLevel);
            } else {
                for (Pair<class_6880<class_1320>, class_2960> modifierPair : LunarRegistry.instance().getEventModifiers()) {
                    serverLevel.method_27909().forEach(entity -> {
                        if (entity instanceof class_1309) {
                            class_1324 modifier;
                            class_1309 livingEntity = (class_1309)entity;
                            if (!entity.method_7325() && (modifier = livingEntity.method_5996((class_6880)modifierPair.getLeft())) != null) {
                                modifier.method_6200((class_2960)modifierPair.getRight());
                            }
                        }
                    });
                }
            }
        }
    }

    public static void onLevelTick(class_1937 level) {
        class_3218 serverLevel;
        LunarPhaseData phaseData;
        ILunarEvent event;
        if (level.method_8510() % 20L == 0L && level instanceof class_3218 && (event = (phaseData = LunarPhaseData.get((class_1937)(serverLevel = (class_3218)level))).getActiveLunarEvent()) != null) {
            serverLevel.method_27909().forEach(entity -> {
                if (entity.method_7325()) {
                    return;
                }
                event.removeEntityEffect((class_1297)entity);
            });
        }
    }

    public static EventResult canSleep(class_1657 player, class_2338 sleepingPos) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        class_1937 level = player.method_37908();
        if (!level.field_9236 && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null) {
            EventResult result = lunarEvent.canSleep(player, sleepingPos);
            if (result == EventResult.DENY) {
                class_5250 denyComponent = class_2561.method_43469((String)"lunar.event.sleep_canceled", (Object[])new Object[]{class_2561.method_43471((String)lunarEvent.getTranslationKey())}).method_27692(class_124.field_1061);
                player.method_7353((class_2561)denyComponent, true);
            }
            return result;
        }
        return EventResult.DEFAULT;
    }

    public static EventResult getSpawnResult(class_3730 mobSpawnType, class_1309 livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        class_1937 level = livingEntity.method_37908();
        if (!level.field_9236 && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.dictatesMobSpawn()) {
            return lunarEvent.getSpawnResult(livingEntity, mobSpawnType);
        }
        return EventResult.DEFAULT;
    }

    public static void uponLivingSpawn(class_3730 mobSpawnType, class_1309 livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        class_1937 level = livingEntity.method_37908();
        if (!level.field_9236 && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.applySpawnEffect()) {
            lunarEvent.applySpawnEffect(livingEntity, mobSpawnType);
        }
    }
}

