/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.platform.Services;
import com.mrbysco.lunar.registry.LunarRegistry;
import java.util.Random;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LunarPhaseData
extends SavedData {
    private static final Random random = new Random();
    private static final String DATA_NAME = "lunar_world_data";
    public ILunarEvent forcedEvent;
    public ILunarEvent activeEvent;

    public LunarPhaseData() {
        this.setActiveEvent(null);
        this.setForcedEvent(null);
    }

    public LunarPhaseData(ILunarEvent event, ILunarEvent forcedEvent) {
        this.setActiveEvent(event);
        this.setForcedEvent(forcedEvent);
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.activeEvent != null) {
            compound.putString("event", this.activeEvent.getID().toString());
        }
        if (this.forcedEvent != null) {
            compound.putString("forcedEvent", this.forcedEvent.getID().toString());
        }
        return compound;
    }

    public static LunarPhaseData load(CompoundTag compound, HolderLookup.Provider provider) {
        ResourceLocation eventID = compound.getString("event").isEmpty() ? null : ResourceLocation.tryParse((String)compound.getString("event"));
        ILunarEvent event = eventID != null ? LunarRegistry.instance().getEventByID(eventID) : null;
        ResourceLocation forcedEventID = compound.getString("forcedEvent").isEmpty() ? null : ResourceLocation.tryParse((String)compound.getString("forcedEvent"));
        ILunarEvent forcedEvent = forcedEventID != null ? LunarRegistry.instance().getEventByID(forcedEventID) : null;
        return new LunarPhaseData(event, forcedEvent);
    }

    public static LunarPhaseData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = level.getServer().getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (LunarPhaseData)storage.computeIfAbsent(new SavedData.Factory(LunarPhaseData::new, LunarPhaseData::load, null), DATA_NAME);
    }

    public void setRandomLunarEvent(Level level) {
        if (this.forcedEvent != null) {
            MutableComponent startComponent = Component.translatable((String)"lunar.event.start", (Object[])new Object[]{Component.translatable((String)this.forcedEvent.getTranslationKey())});
            level.players().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$0((Component)startComponent, arg_0));
            this.setActiveEvent(this.forcedEvent);
            this.setForcedEvent(null);
        } else {
            ILunarEvent event;
            float rng = random.nextFloat();
            if (rng <= Services.PLATFORM.getLunarChance() && (event = LunarRegistry.instance().getRandomLunarEvent(level)) != null) {
                MutableComponent startComponent = Component.translatable((String)"lunar.event.start", (Object[])new Object[]{Component.translatable((String)event.getTranslationKey())});
                level.players().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$1((Component)startComponent, arg_0));
                this.setActiveEvent(event);
                return;
            }
            this.setDefaultMoon();
        }
    }

    public void setForcedEvent(ILunarEvent event) {
        this.forcedEvent = event;
        this.setDirty();
    }

    public void eraseEvent() {
        this.setActiveEvent(null);
    }

    public void setDefaultMoon() {
        this.setActiveEvent(LunarRegistry.getDefaultMoon());
        this.setForcedEvent(null);
    }

    public void setActiveEvent(ILunarEvent storage) {
        this.activeEvent = storage;
        this.setDirty();
    }

    public void syncEvent(Level level) {
        Services.PLATFORM.syncEvent(level, this.activeEvent != null ? this.activeEvent : null);
    }

    public void syncEvent(ServerPlayer player) {
        Services.PLATFORM.syncEvent(player, this.activeEvent != null ? this.activeEvent : null);
    }

    public ILunarEvent getActiveLunarEvent() {
        return this.activeEvent != null ? this.activeEvent : null;
    }

    public boolean hasEventActive() {
        return this.activeEvent != null;
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$1(Component startComponent, Player player) {
        player.sendSystemMessage(startComponent);
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$0(Component startComponent, Player player) {
        player.sendSystemMessage(startComponent);
    }
}

