/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.platform;

import com.google.common.collect.Maps;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.config.LunarConfig;
import com.mrbysco.lunar.network.message.SyncDeltaMovement;
import com.mrbysco.lunar.network.message.SyncEventMessage;
import com.mrbysco.lunar.platform.services.IPlatformHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public void syncEvent(Level level, ILunarEvent event) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncEventMessage(event), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncEvent(ServerPlayer player, ILunarEvent event) {
        player.connection.send((CustomPacketPayload)new SyncEventMessage(event));
    }

    @Override
    public void syncDeltaMovement(ServerPlayer player, Vec3 deltaMovement) {
        player.connection.send((CustomPacketPayload)new SyncDeltaMovement(deltaMovement));
    }

    @Override
    public float getLunarChance() {
        return ((Double)LunarConfig.COMMON.lunarEventChance.get()).floatValue();
    }

    @Override
    public int getBloodMoonWeight() {
        return (Integer)LunarConfig.COMMON.bloodMoonWeight.get();
    }

    @Override
    public int getCrimsonMoonWeight() {
        return (Integer)LunarConfig.COMMON.crimsonMoonWeight.get();
    }

    @Override
    public int getMinerMoonWeight() {
        return (Integer)LunarConfig.COMMON.minerMoonWeight.get();
    }

    @Override
    public int getWhiteMoonWeight() {
        return (Integer)LunarConfig.COMMON.whiteMoonWeight.get();
    }

    @Override
    public int getBigMoonWeight() {
        return (Integer)LunarConfig.COMMON.bigMoonWeight.get();
    }

    @Override
    public int getTinyMoonWeight() {
        return (Integer)LunarConfig.COMMON.tinyMoonWeight.get();
    }

    @Override
    public int getBadOmenMoonWeight() {
        return (Integer)LunarConfig.COMMON.badOmenMoonWeight.get();
    }

    @Override
    public int getHeroMoonWeight() {
        return (Integer)LunarConfig.COMMON.heroMoonWeight.get();
    }

    @Override
    public int getEclipseMoonWeight() {
        return (Integer)LunarConfig.COMMON.eclipseMoonWeight.get();
    }

    @Override
    public Map<ResourceLocation, ResourceLocation> getCrimsonReplacementMap() {
        HashMap map = Maps.newHashMap();
        ((List)LunarConfig.COMMON.crimsonReplacements.get()).forEach(entry -> {
            if (entry.contains(",")) {
                String[] split = entry.split(",");
                map.put(ResourceLocation.tryParse((String)split[0]), ResourceLocation.tryParse((String)split[1]));
            }
        });
        return map;
    }

    @Override
    public boolean canSleepIn(ResourceLocation moonID) {
        boolean result = true;
        switch (moonID.toString()) {
            case "lunar:blood_moon": {
                result = (Boolean)LunarConfig.COMMON.bloodMoonSleeping.get();
                break;
            }
            case "lunar:crimson_moon": {
                result = (Boolean)LunarConfig.COMMON.crimsonMoonSleeping.get();
                break;
            }
            case "lunar:miner_moon": {
                result = (Boolean)LunarConfig.COMMON.minerMoonSleeping.get();
                break;
            }
            case "lunar:white_moon": {
                result = (Boolean)LunarConfig.COMMON.whiteMoonSleeping.get();
                break;
            }
            case "lunar:big_moon": {
                result = (Boolean)LunarConfig.COMMON.bigMoonSleeping.get();
                break;
            }
            case "lunar:tiny_moon": {
                result = (Boolean)LunarConfig.COMMON.tinyMoonSleeping.get();
                break;
            }
            case "lunar:bad_omen_moon": {
                result = (Boolean)LunarConfig.COMMON.badOmenMoonSleeping.get();
                break;
            }
            case "lunar:hero_moon": {
                result = (Boolean)LunarConfig.COMMON.heroMoonSleeping.get();
                break;
            }
            case "lunar:eclipse_moon": {
                result = (Boolean)LunarConfig.COMMON.eclipseMoonSleeping.get();
            }
        }
        return result;
    }

    @Override
    public int maxBadOmen() {
        return (Integer)LunarConfig.COMMON.maxBadOmen.get();
    }
}

