/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;

public class WhiteMoonEvent
extends LunarEvent {
    private static final ResourceLocation MOON_TEXTURE = Constants.modLoc("textures/environment/white.png");

    public WhiteMoonEvent() {
        super(Constants.modLoc("white_moon"), 0x1F1F1F);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getWhiteMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.white_moon";
    }

    @Override
    public boolean applyPlayerEffect() {
        return true;
    }

    @Override
    public boolean dictatesMobSpawn() {
        return true;
    }

    @Override
    public EventResult getSpawnResult(LivingEntity livingEntity, MobSpawnType spawnType) {
        if (spawnType == MobSpawnType.NATURAL && livingEntity.getType().getCategory() == MobCategory.MONSTER) {
            return EventResult.DENY;
        }
        return EventResult.ALLOW;
    }

    @Override
    public ResourceLocation moonTexture() {
        return MOON_TEXTURE;
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        if (!Services.PLATFORM.canSleepIn(this.getID())) {
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }
}

