/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.utils;

import com.danrus.PlayerArmorStands;
import com.danrus.utils.StringUtils;
import com.danrus.utils.skin.SkinsUtils;
import net.minecraft.class_2960;

public class PASModelData {
    public static class_2960 DEFAULT_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
    public static class_2960 DEFAULT_CAPE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/cape.png");
    public String name;
    public class_2960 texture;
    public class_2960 cape = DEFAULT_CAPE;
    public DownloadStatus status = DownloadStatus.NOT_STARTED;

    public PASModelData(String name) {
        this.name = name;
        this.texture = DEFAULT_TEXTURE;
    }

    public PASModelData(String name, class_2960 texture) {
        this.name = name;
        this.texture = texture;
    }

    public PASModelData(String name, DownloadStatus status) {
        this.name = name;
        this.texture = DEFAULT_TEXTURE;
        this.status = status;
    }

    public PASModelData(String name, class_2960 texture, DownloadStatus status) {
        this.name = name;
        this.texture = texture;
        this.status = status;
    }

    public PASModelData(String name, class_2960 texture, class_2960 cape, DownloadStatus status) {
        this.name = name;
        this.texture = texture;
        this.status = status;
        this.cape = cape;
    }

    public PASModelData(String name, class_2960 texture, class_2960 cape) {
        this.name = name;
        this.texture = texture;
        this.cape = cape;
    }

    public static PASModelData getByName(String string) {
        String name = StringUtils.matchASName(string).getFirst();
        boolean hasCape = StringUtils.matchASName(string).get(1).contains("C");
        if (hasCape && PlayerArmorStands.modelDataCache.containsKey(name) && PlayerArmorStands.modelDataCache.get((Object)name).cape == DEFAULT_CAPE) {
            class_2960 capeId = class_2960.method_60655((String)"pas", (String)("capes/" + StringUtils.encodeToSha256(name) + ".png"));
            PASModelData.registerCape(name, capeId);
        }
        if (!name.isEmpty() && PlayerArmorStands.modelDataCache.containsKey(name)) {
            return PlayerArmorStands.modelDataCache.get(name);
        }
        PASModelData defaultData = new PASModelData(name, DEFAULT_TEXTURE, DownloadStatus.IN_PROGRESS);
        PASModelData.register(defaultData);
        SkinsUtils.getSkinTexture(name);
        return defaultData;
    }

    private static void register(PASModelData data) {
        PlayerArmorStands.modelDataCache.put(data.name, data);
    }

    private static void register(String name, class_2960 texture, DownloadStatus status) {
        PASModelData.register(new PASModelData(name, texture, status));
    }

    public static void registerFailed(String name) {
        PASModelData.register(name, DEFAULT_TEXTURE, DownloadStatus.FAILED);
    }

    public static void registerNotFound(String name) {
        PASModelData.register(name, DEFAULT_TEXTURE, DownloadStatus.NOT_FOUND);
    }

    public static void registerCompleted(String name, class_2960 texture) {
        PASModelData.register(name, texture, DownloadStatus.COMPLETED);
    }

    public static void registerCape(String name, class_2960 cape) {
        if (PlayerArmorStands.modelDataCache.containsKey(name)) {
            PASModelData data = PlayerArmorStands.modelDataCache.get(name);
            data.cape = cape;
            PlayerArmorStands.modelDataCache.put(name, data);
        } else {
            PASModelData.register(new PASModelData(name, DEFAULT_TEXTURE, cape, DownloadStatus.COMPLETED));
        }
    }

    public static enum DownloadStatus {
        NOT_STARTED,
        IN_PROGRESS,
        COMPLETED,
        FAILED,
        NOT_FOUND;


        public boolean isCompleted() {
            return this == COMPLETED;
        }

        public boolean inProgress() {
            return this == IN_PROGRESS;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean notFound() {
            return this == NOT_FOUND;
        }

        public boolean shouldDownload() {
            return this == NOT_STARTED || this == IN_PROGRESS;
        }
    }
}

