/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.compat.possessive.mixin;

import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.SkinData;
import com.danrus.pas.compat.possessive.PossessiveRenderHand;
import com.danrus.pas.config.ModConfig;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.render.armorstand.PlayerArmorStandModel;
import com.danrus.pas.utils.Rl;
import java.util.List;
import net.just_s.camera.ArmorStandCamera;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_877;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ArmorStandCamera.class})
public class ArmorStandCameraMixin {
    @Shadow
    @Final
    private class_1531 possessedArmorStand;

    @Unique
    private static PossessiveRenderHand resolveHand(class_630 playerHand, class_591 playerModel, PlayerArmorStandModel armorStandModel, NameInfo info) {
        if (playerHand.equals(playerModel.field_3401)) {
            if (ModConfig.get().possessiveShowDefaultHand) {
                return PossessiveRenderHand.RIGHT_ORIGINAL;
            }
            if (info.wantBeSlim()) {
                return PossessiveRenderHand.RIGHT_SLIM;
            }
            if (info.isEmpty()) {
                return PossessiveRenderHand.RIGHT_WIDE;
            }
            return PossessiveRenderHand.RIGHT_ORIGINAL;
        }
        if (ModConfig.get().possessiveShowDefaultHand) {
            return PossessiveRenderHand.LEFT_ORIGINAL;
        }
        if (info.wantBeSlim()) {
            return PossessiveRenderHand.LEFT_SLIM;
        }
        if (!info.isEmpty()) {
            return PossessiveRenderHand.LEFT_WIDE;
        }
        return PossessiveRenderHand.LEFT_ORIGINAL;
    }

    private static List<class_630> getPartsForRender(PossessiveRenderHand hand, PlayerArmorStandModel armorStandModel) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case PossessiveRenderHand.LEFT_ORIGINAL -> List.of(armorStandModel.originalLeftArm);
            case PossessiveRenderHand.RIGHT_ORIGINAL -> List.of(armorStandModel.originalRightArm);
            case PossessiveRenderHand.LEFT_WIDE -> List.of(armorStandModel.field_27433, armorStandModel.leftSleeve);
            case PossessiveRenderHand.RIGHT_WIDE -> List.of(armorStandModel.field_3401, armorStandModel.rightSleeve);
            case PossessiveRenderHand.LEFT_SLIM -> List.of(armorStandModel.leftSlimArm, armorStandModel.leftSlimSleeve);
            case PossessiveRenderHand.RIGHT_SLIM -> List.of(armorStandModel.rightSlimArm, armorStandModel.rightSlimSleeve);
        };
    }

    @Overwrite
    public void onRenderHand(class_4587 poseStack, class_4597 multiBufferSource, int i, class_2960 resourceLocation, class_630 modelPart, boolean bl) {
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_877 entityRenderer = (class_877)entityRenderDispatcher.method_3953((class_1297)this.possessedArmorStand);
        class_1007 playerRenderer = (class_1007)entityRenderDispatcher.method_3953((class_1297)class_310.method_1551().field_1724);
        class_591 playerModel = (class_591)playerRenderer.method_4038();
        PlayerArmorStandModel armorStandModel = (PlayerArmorStandModel)entityRenderer.method_4038();
        NameInfo info = this.possessedArmorStand.method_5797() != null ? NameInfo.parse(this.possessedArmorStand.method_5797().getString()) : new NameInfo();
        PossessiveRenderHand resolvedHand = ArmorStandCameraMixin.resolveHand(modelPart, playerModel, armorStandModel, info);
        float leftZRot = -0.1f;
        float rightZRot = 0.1f;
        armorStandModel.field_27433.field_3674 = leftZRot;
        armorStandModel.field_3401.field_3674 = rightZRot;
        armorStandModel.originalLeftArm.field_3674 = leftZRot;
        armorStandModel.originalRightArm.field_3674 = rightZRot;
        armorStandModel.leftSleeve.field_3674 = leftZRot;
        armorStandModel.rightSleeve.field_3674 = rightZRot;
        armorStandModel.leftSlimArm.field_3674 = leftZRot;
        armorStandModel.rightSlimArm.field_3674 = rightZRot;
        armorStandModel.leftSlimSleeve.field_3674 = leftZRot;
        armorStandModel.rightSlimSleeve.field_3674 = rightZRot;
        class_2960 skinTexture = !info.isEmpty() ? (ModConfig.get().possessiveShowDefaultHand ? Rl.vanilla("textures/entity/armorstand/wood.png") : PasManager.getInstance().getSkinTexture(info)) : SkinData.DEFAULT_TEXTURE;
        ArmorStandCameraMixin.getPartsForRender(resolvedHand, armorStandModel).forEach(armorStandArm -> {
            armorStandArm.method_41923();
            armorStandArm.field_3665 = true;
            armorStandArm.method_22698(poseStack, multiBufferSource.getBuffer(class_1921.method_23580((class_2960)skinTexture)), i, class_4608.field_21444);
        });
    }
}

