/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.danrus.pas.ModExecutor;
import com.danrus.pas.utils.TextureUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SkinDownloader {
    public static CompletableFuture<class_2960> downloadAndRegister(class_2960 texture, Path path, String uri, boolean remap) {
        return CompletableFuture.supplyAsync(() -> {
            class_1011 nativeImage;
            try {
                nativeImage = SkinDownloader.download(path, uri);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            return nativeImage;
        }, ModExecutor.DOWNLOAD_EXECUTOR).thenCompose(image -> TextureUtils.registerTexture(image, texture, remap));
    }

    private static class_1011 download(Path path, String uri) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                class_1011 class_10112 = class_1011.method_4309((InputStream)inputStream);
                return class_10112;
            }
        }
        int maxRetries = 3;
        int currentTry = 0;
        IOException lastException = null;
        while (currentTry < maxRetries) {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)URI.create(uri).toURL().openConnection(class_310.method_1551().method_1487());
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 Minecraft Client");
                connection.setConnectTimeout(15000);
                connection.setReadTimeout(15000);
                connection.setDoInput(true);
                connection.setDoOutput(false);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    byte[] data = connection.getInputStream().readAllBytes();
                    try {
                        Files.write(path, data, new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    class_1011 class_10113 = class_1011.method_49277((byte[])data);
                    return class_10113;
                }
                ++currentTry;
                Thread.sleep(1000L);
            }
            catch (IOException e) {
                lastException = e;
                ++currentTry;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Download interrupted", e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Download interrupted");
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
        throw new IOException("Failed to download after " + maxRetries + " attempts", lastException);
    }
}

