/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.api.data;

import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.impl.features.CapeFeature;
import com.danrus.pas.impl.features.SkinProviderFeature;
import java.util.Objects;

public record DataStoreKey(String baseName, String provider, DataType dataType) {
    public static DataStoreKey forSkin(NameInfo info) {
        return new DataStoreKey(info.base(), info.getFeature(SkinProviderFeature.class).getProvider(), DataType.SKIN);
    }

    public static DataStoreKey forCape(NameInfo info) {
        return new DataStoreKey(info.getFeature(CapeFeature.class).getId().isEmpty() ? info.base() : info.getFeature(CapeFeature.class).getId(), info.getFeature(CapeFeature.class).getProvider(), DataType.CAPE);
    }

    public static DataStoreKey fromString(String key) {
        String[] parts = key.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid key format: " + key);
        }
        return new DataStoreKey(parts[0], parts[1], DataType.valueOf(parts[2]));
    }

    public NameInfo toNameInfo() {
        NameInfo info = new NameInfo(this.baseName);
        switch (this.dataType.ordinal()) {
            case 0: {
                SkinProviderFeature skinFeature = info.getFeature(SkinProviderFeature.class);
                if (skinFeature == null) break;
                skinFeature.setProvider(this.provider);
                break;
            }
            case 1: {
                CapeFeature capeFeature = info.getFeature(CapeFeature.class);
                if (capeFeature == null) break;
                capeFeature.setId(this.baseName);
                info.setName(this.baseName);
                capeFeature.setEnabled(true);
            }
        }
        return info;
    }

    public String asString() {
        return this.baseName + ":" + this.provider + ":" + this.dataType.name();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataStoreKey)) {
            return false;
        }
        DataStoreKey other = (DataStoreKey)obj;
        return Objects.equals(this.baseName, other.baseName) && Objects.equals(this.provider, other.provider) && this.dataType == other.dataType;
    }

    @Override
    public String toString() {
        return "DataStoreKey[" + this.asString() + "]";
    }

    public static enum DataType {
        SKIN,
        CAPE,
        ELYTRA;

    }
}

