/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.providers;

import com.danrus.pas.ModExecutor;
import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.SkinData;
import com.danrus.pas.api.TextureProvider;
import com.danrus.pas.impl.data.MojangDiskData;
import com.danrus.pas.managers.OverlayMessageManger;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.RestHelper;
import com.danrus.pas.utils.Rl;
import com.danrus.pas.utils.SkinDownloader;
import com.danrus.pas.utils.StringUtils;
import com.google.gson.Gson;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public class MojangSkinProvider
implements TextureProvider {
    private static final String MOJANG_API_URL = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String SESSION_SERVER_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final int MAX_USERNAME_LENGTH = 16;
    private static final String USERNAME_PATTERN = "[a-zA-Z0-9_]+";
    private final Gson gson = new Gson();
    private String literal = "M";
    private Consumer<String> onComplete;
    private String output;

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public void load(NameInfo info, Consumer<String> onComplete) {
        this.onComplete = onComplete;
        this.output = info.base();
        if (!this.isValidName(info.base())) {
            OverlayMessageManger.getInstance().showInvalidNameMessage(info.base());
            ModExecutor.execute(() -> PasManager.getInstance().getDataManager().invalidateData(info));
            return;
        }
        this.initializeDownload(info);
        ModExecutor.execute(() -> this.downloadProfile(info));
    }

    private void initializeDownload(NameInfo info) {
        PlayerArmorStandsClient.LOGGER.info("MojangSkinProvider: Downloading skin for " + String.valueOf(info));
        SkinData data = new SkinData(info);
        OverlayMessageManger.getInstance().showDownloadMessage(info.base());
        data.setStatus(DownloadStatus.IN_PROGRESS);
        PasManager.getInstance().getDataManager().store(info, data);
    }

    private void downloadProfile(NameInfo info) {
        ((CompletableFuture)RestHelper.get(MOJANG_API_URL + info.base()).thenApply(response -> this.processSimpleProfile((String)response, info))).exceptionally(throwable -> {
            this.doFail(info);
            PlayerArmorStandsClient.LOGGER.error("MojangSkinProvider: Failed to download skin for " + String.valueOf(info), throwable);
            return null;
        });
    }

    private CompletableFuture<?> processSimpleProfile(String response, NameInfo info) {
        SimpleProfile simpleProfile = (SimpleProfile)this.gson.fromJson(response, SimpleProfile.class);
        if (simpleProfile == null || simpleProfile.id == null) {
            this.doFail(info);
            return null;
        }
        return this.downloadTexturedProfile(simpleProfile.id, info);
    }

    private CompletableFuture<?> downloadTexturedProfile(String uuid, NameInfo info) {
        return ((CompletableFuture)RestHelper.get(SESSION_SERVER_URL + uuid).thenApply(response -> this.processTexturedProfile((String)response, info))).exceptionally(throwable -> {
            this.doFail(info);
            return null;
        });
    }

    private Void processTexturedProfile(String response, NameInfo info) {
        Profile profile = (Profile)this.gson.fromJson(response, Profile.class);
        if (!this.isValidProfile(profile)) {
            this.doFail(info);
            return null;
        }
        String encodedSkin = StringUtils.decodeBase64(profile.properties[0].value);
        String encodedName = StringUtils.encodeToSha256(info.base());
        TexturedProfile texturedProfile = (TexturedProfile)this.gson.fromJson(encodedSkin, TexturedProfile.class);
        if (!this.isValidTexturedProfile(texturedProfile)) {
            this.doFail(info);
            return null;
        }
        this.processSkinTexture(texturedProfile, encodedName, info);
        this.processCapeTexture(texturedProfile, encodedName, info);
        return null;
    }

    private void processSkinTexture(TexturedProfile profile, String encodedName, NameInfo info) {
        if (profile.textures.SKIN != null && profile.textures.SKIN.url != null) {
            class_2960 skinIdentifier = Rl.pas("skins/" + encodedName);
            this.downloadAndRegisterTexture(skinIdentifier, encodedName + ".png", profile.textures.SKIN.url, true, info, true);
        }
    }

    private void processCapeTexture(TexturedProfile profile, String encodedName, NameInfo info) {
        if (profile.textures.CAPE != null && profile.textures.CAPE.url != null) {
            class_2960 capeIdentifier = Rl.pas("capes/" + encodedName);
            this.downloadAndRegisterTexture(capeIdentifier, encodedName + "_cape.png", profile.textures.CAPE.url, false, info, false);
        }
    }

    private void downloadAndRegisterTexture(class_2960 identifier, String fileName, String url, boolean isSkin, NameInfo info, boolean updateStatus) {
        ((CompletableFuture)SkinDownloader.downloadAndRegister(identifier, MojangDiskData.CACHE_PATH.resolve(fileName), url, isSkin).thenAccept(textureId -> this.updateModelData(info, (class_2960)textureId, isSkin))).thenAccept(ignored -> {
            if (updateStatus) {
                OverlayMessageManger.getInstance().showSuccessMessage(info.base());
                PlayerArmorStandsClient.LOGGER.info("MojangSkinProvider: Successfully downloaded skin for " + String.valueOf(info));
                this.onComplete.accept(this.output);
                this.updateStatus(info, DownloadStatus.COMPLETED);
            }
        });
    }

    private void updateModelData(NameInfo info, class_2960 textureId, boolean isSkin) {
        SkinData data = this.getOrCreateModelData(info);
        if (isSkin) {
            data.setSkinTexture(textureId);
        } else {
            data.setCapeTexture(textureId);
        }
        PasManager.getInstance().getDataManager().store(info, data);
    }

    private void updateStatus(NameInfo info, DownloadStatus status) {
        SkinData data = this.getOrCreateModelData(info);
        data.setStatus(status);
        PasManager.getInstance().getDataManager().store(info, data);
    }

    private SkinData getOrCreateModelData(NameInfo info) {
        SkinData data = PasManager.getInstance().getData(info);
        return data != null ? data : new SkinData(info);
    }

    private boolean isValidProfile(Profile profile) {
        return profile != null && profile.id != null && profile.properties != null && profile.properties.length > 0;
    }

    private boolean isValidTexturedProfile(TexturedProfile profile) {
        return profile != null && profile.textures != null;
    }

    private boolean isValidName(String name) {
        return name != null && !name.isEmpty() && name.length() <= 16 && name.matches(USERNAME_PATTERN);
    }

    private void doFail(NameInfo info) {
        SkinData data = PasManager.getInstance().getData(info);
        if (data == null) {
            data = new SkinData(info);
        }
        OverlayMessageManger.getInstance().showFailMessage(info.base());
        data.setStatus(DownloadStatus.FAILED);
        PasManager.getInstance().getDataManager().store(info, data);
    }

    class SimpleProfile {
        public String id;
        public String name;

        SimpleProfile(MojangSkinProvider this$0) {
        }
    }

    class Profile {
        public String id;
        public String name;
        public ProfileProperty[] properties;

        Profile(MojangSkinProvider this$0) {
        }

        class ProfileProperty {
            public String name;
            public String value;

            ProfileProperty(Profile this$1) {
            }
        }
    }

    class TexturedProfile {
        public Textures textures;

        TexturedProfile(MojangSkinProvider this$0) {
        }

        class Textures {
            public Texture SKIN;
            public Texture CAPE;

            Textures(TexturedProfile this$1) {
            }

            class Texture {
                public String url;

                Texture(Textures this$2) {
                }
            }
        }
    }
}

