/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.managers;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DataHolder;
import com.danrus.pas.api.DataManager;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.SkinData;
import com.danrus.pas.impl.data.ClientLevelData;
import com.danrus.pas.impl.data.FileTextureData;
import com.danrus.pas.impl.data.GameData;
import com.danrus.pas.impl.data.MojangDiskData;
import com.danrus.pas.impl.data.NamemcDiskData;
import com.danrus.pas.managers.PasManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class SkinDataManager
implements DataManager {
    private final List<DataHolder<?>> sources = new CopyOnWriteArrayList();

    public SkinDataManager() {
        this.addSource(new ClientLevelData(), 0);
        this.addSource(new GameData(), 2);
        this.addSource(new MojangDiskData());
        this.addSource(new NamemcDiskData());
        this.addSource(new FileTextureData(), 999);
    }

    @Override
    public void addSource(DataHolder<?> source) {
        this.sources.add(source);
    }

    @Override
    public void addSource(DataHolder<?> source, int priority) {
        if (priority >= this.sources.size()) {
            this.sources.add(source);
        } else {
            this.sources.add(priority, source);
        }
    }

    @Override
    public DataHolder<?> getSource(String key) {
        return this.sources.stream().filter(source -> source.getName().equals(key)).findFirst().orElse(null);
    }

    @Override
    public HashMap<String, SkinData> getGameData() {
        return this.sources.stream().map(source -> source).map(DataHolder::getAll).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, HashMap::new));
    }

    @Override
    public SkinData findData(NameInfo info) {
        DataHolder<?> gameCache;
        DataHolder<?> source = this.getSource("game");
        DataHolder<Object> dataHolder = gameCache = source instanceof DataHolder ? source : null;
        if (gameCache != null) {
            return gameCache.get(info);
        }
        return null;
    }

    @Override
    public void delete(NameInfo info) {
        this.sources.forEach(source -> {
            if (source.delete(info)) {
                PlayerArmorStandsClient.LOGGER.info("Deleted data from source: " + source.getName() + " for string: " + String.valueOf(info));
            }
        });
    }

    public HashMap<String, DataHolder<?>> getSources() {
        return this.sources.stream().collect(Collectors.toMap(DataHolder::getName, source -> source, (a, b) -> b, HashMap::new));
    }

    @Override
    public SkinData getData(NameInfo info) {
        AtomicReference<SkinData> data = new AtomicReference<SkinData>(new SkinData(info));
        AtomicBoolean needDownload = new AtomicBoolean(true);
        this.sources.forEach(source -> {
            SkinData dataFromSource;
            SkinData skinData = dataFromSource = needDownload.get() ? source.get(info) : null;
            if (dataFromSource != null) {
                needDownload.set(false);
                data.set(dataFromSource);
            }
        });
        if (needDownload.get() && data.get().getStatus() == DownloadStatus.NOT_STARTED) {
            data.get().setStatus(DownloadStatus.IN_PROGRESS);
            this.store(info, data.get());
            PasManager.getInstance().getSkinProviderManager().download(info);
        }
        return data.get();
    }

    @Override
    public void store(NameInfo info, Object data) {
        this.sources.forEach(source -> {
            if (source.isCompatibleWith(data)) {
                source.store(info, data);
            }
        });
    }

    @Override
    public void invalidateData(NameInfo info) {
        this.sources.forEach(source -> source.invalidateData(info));
    }
}

