/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.gui.tabs;

import com.danrus.pas.render.gui.tabs.Tab;
import com.danrus.pas.render.gui.widgets.TabButton;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_339;
import net.minecraft.class_437;

public class TabManager {
    private final class_437 screen;
    private final Map<TabButton, Tab> tabs = new LinkedHashMap<TabButton, Tab>();
    private Tab activeTab;

    public TabManager(class_437 screen) {
        this.screen = screen;
    }

    public void addTab(TabButton button, Tab tab) {
        this.tabs.put(button, tab);
        button.tabOnPress = b -> this.setActiveTab(tab);
        if (this.activeTab == null) {
            this.setActiveTab(tab);
        } else {
            tab.setVisible(false);
        }
    }

    public void setActiveTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        if (this.activeTab != null) {
            this.activeTab.setVisible(false);
        }
        this.activeTab = tab;
        if (this.activeTab != null) {
            this.activeTab.setVisible(true);
        }
        this.tabs.forEach((btn, t) -> {
            btn.field_22763 = t != this.activeTab;
        });
    }

    public void init() {
        for (Tab tab : this.tabs.values()) {
            tab.init(this.screen);
        }
    }

    public void reposition(int width, int height) {
        if (this.activeTab != null) {
            this.activeTab.reposition(width, height);
        }
    }

    public List<class_339> getAllWidgets() {
        ArrayList<class_339> allWidgets = new ArrayList<class_339>();
        this.tabs.values().forEach(tab -> allWidgets.addAll(tab.getWidgets()));
        return allWidgets;
    }

    public Tab getActiveTab() {
        return this.activeTab;
    }
}

