package com.danrus.utils.skin;

import com.danrus.PlayerArmorStands;
import com.danrus.utils.PASModelData;
import com.danrus.utils.StringUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import java.nio.file.Path;

public class SkinsUtils {

    public static Path CACHE_DIR = FabricLoader.getInstance().getGameDir().resolve("cache/pas");
    public static class_2960 DEFAULT_TEXTURE = class_2960.method_43902("minecraft", "textures/entity/player/wide/steve.png");

    public static void reloadSkinTexure(String name) {
        if (!CACHE_DIR.resolve(StringUtils.encodeToSha256(name)+".png").toFile().delete()) {
            class_310.method_1551().field_1705.method_1758(class_2561.method_43470("§aFailed to delete texture for " + name), false);
        } else {
            PASSkinDownloader.registerSkin(CACHE_DIR.resolve(StringUtils.encodeToSha256(name)+".png"), name, class_2960.method_43902("pas", "skins/" + StringUtils.encodeToSha256(name) + ".png"));
        }
        getSkinTexture(name);
    }

    public static class_2960 getSkinTexture(String name) {

//        if (MinecraftClient.getInstance().getTextureManager().getTexture(
//                Identifier.of("pas", "skins/" + StringUtils.encodeToSha256(name) + ".png")
//        ) instanceof MissingSprite) {
//            return DEFAULT_TEXTURE; //TODO антифиолет не работает, поспи сначала а потом напиши
//        }

        if (PlayerArmorStands.modelDataCache.containsKey(name) && PlayerArmorStands.modelDataCache.get(name).status.isCompleted()) {
            PASModelData modelData = PlayerArmorStands.modelDataCache.get(name);
            return modelData.texture;
        }

        String encodedName = StringUtils.encodeToSha256(name);

        if (CACHE_DIR.resolve(encodedName + "_cape.png").toFile().exists()) {
            class_2960 capeId = class_2960.method_43902("pas", "capes/" + encodedName + ".png");
            PASSkinDownloader.registerCape(CACHE_DIR.resolve(encodedName + "_cape.png"), name, capeId);
            PASModelData.registerCape(name, capeId);
        }

        if (CACHE_DIR.resolve(encodedName + ".png").toFile().exists()) {
            class_2960 id = class_2960.method_43902("pas", "skins/" + encodedName + ".png");
            PASSkinDownloader.registerSkin(CACHE_DIR.resolve(encodedName+".png"), name, id);
            PASModelData.registerCompleted(name, id);
            return id;
        }

        class_310.method_1551().field_1705.method_1758(class_2561.method_43469("pas.downloading", name).method_27692(class_124.field_1078), false);
        PASSkinDownloader.downloadSkin(name);
        return DEFAULT_TEXTURE;
    }


}
