/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.utils.skin;

import com.danrus.PASExecutor;
import com.danrus.PlayerArmorStands;
import com.danrus.api.MojangApi;
import com.danrus.utils.PASModelData;
import com.danrus.utils.StringUtils;
import com.danrus.utils.skin.SkinsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9848;

public class PASSkinDownloader {
    public static void downloadSkin(String username) {
        PASExecutor.execute(() -> {
            if (!MojangApi.isValidUsername(username)) {
                class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"pas.invalid_username", (Object[])new Object[]{username}).method_27692(class_124.field_1061), false);
                PASModelData.registerFailed(username);
                return;
            }
            MojangApi.getProfileDataByNameAsync(username).thenAccept(profile -> {
                if (profile == null) {
                    PASSkinDownloader.doFailure(username, new Exception("Profile not found for: " + username));
                }
                MojangApi.getTexturedDataByUUIDAsync(profile.id).thenAccept(texturedProfile -> {
                    try {
                        String capeUrl;
                        if (texturedProfile == null || texturedProfile.properties == null || texturedProfile.properties.isEmpty()) {
                            PASSkinDownloader.doFailure(username, new Exception("No textures found for: " + username));
                        }
                        String encodedData = texturedProfile.properties.getFirst().value;
                        String decodedData = StringUtils.decodeBase64(encodedData);
                        MojangApi.SkinData skinData = (MojangApi.SkinData)PlayerArmorStands.GSON.fromJson(decodedData, MojangApi.SkinData.class);
                        String url = skinData.textures.SKIN.url;
                        String encodedName = StringUtils.encodeToSha256(username);
                        class_2960 id = class_2960.method_60655((String)"pas", (String)("skins/" + encodedName));
                        PASSkinDownloader.downloadAndRegisterSkin(id, SkinsUtils.CACHE_DIR.resolve(encodedName + ".png"), url, true);
                        String string = capeUrl = skinData.textures.CAPE != null ? skinData.textures.CAPE.url : null;
                        if (capeUrl != null && !capeUrl.isEmpty()) {
                            class_2960 capeId = class_2960.method_60655((String)"pas", (String)("capes/" + encodedName));
                            PASSkinDownloader.downloadAndRegisterSkin(capeId, SkinsUtils.CACHE_DIR.resolve(encodedName + "_cape.png"), capeUrl, false).thenAccept(capeTextureId -> PASModelData.registerCape(username, capeTextureId));
                        }
                        class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"pas.download_success", (Object[])new Object[]{username}).method_27692(class_124.field_1060), false);
                        PASModelData.registerCompleted(username, id);
                    }
                    catch (Exception e) {
                        PASSkinDownloader.doFailure(username, e);
                    }
                });
            });
        });
    }

    private static CompletableFuture<class_2960> downloadAndRegisterSkin(class_2960 textureId, Path path, String uri, boolean remap) {
        return CompletableFuture.supplyAsync(() -> {
            class_1011 nativeImage;
            try {
                nativeImage = PASSkinDownloader.download(path, uri);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            if (remap) {
                nativeImage = PASSkinDownloader.remapTexture(nativeImage);
            }
            return nativeImage;
        }, PASExecutor.DOWNLOAD_EXECUTOR).thenCompose(image -> PASSkinDownloader.registerSkin(textureId, image));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_1011 download(Path path, String uri) throws IOException {
        class_1011 iOException;
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                class_1011 class_10112 = class_1011.method_4309((InputStream)inputStream);
                return class_10112;
            }
        }
        HttpURLConnection httpURLConnection = null;
        URI uRI = URI.create(uri);
        try {
            httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection(class_310.method_1551().method_1487());
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            int i = httpURLConnection.getResponseCode();
            if (i / 100 != 2) {
                String var10002 = String.valueOf(uRI);
                throw new IOException("Failed to open " + var10002 + ", HTTP error code: " + i);
            }
            byte[] bs = httpURLConnection.getInputStream().readAllBytes();
            try {
                Files.write(path, bs, new OpenOption[0]);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException = class_1011.method_49277((byte[])bs);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return iOException;
    }

    private static CompletableFuture<class_2960> registerSkin(class_2960 textureId, class_1011 image) {
        class_310 minecraftClient = class_310.method_1551();
        return CompletableFuture.supplyAsync(() -> {
            class_1043 texture = new class_1043(image);
            minecraftClient.method_1531().method_4616(textureId, (class_1044)texture);
            return textureId;
        }, (Executor)minecraftClient);
    }

    private static void doFailure(String name, Exception e) {
        e.printStackTrace();
        class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"pas.download_failed", (Object[])new Object[]{name}), false);
        PASModelData.registerFailed(name);
    }

    public static void registerSkin(Path skinPath, String name, class_2960 id) {
        try (InputStream inputStream = Files.newInputStream(skinPath, new OpenOption[0]);){
            class_1011 image = PASSkinDownloader.remapTexture(class_1011.method_4309((InputStream)inputStream));
            class_1043 texture = new class_1043(image);
            class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
            PASModelData.registerCompleted(name, id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerCape(Path capePath, String name, class_2960 id) {
        try (InputStream inputStream = Files.newInputStream(capePath, new OpenOption[0]);){
            class_1011 image = class_1011.method_4309((InputStream)inputStream);
            class_1043 texture = new class_1043(image);
            class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
            PASModelData.registerCape(name, id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class_1011 remapTexture(class_1011 image) {
        int i = image.method_4323();
        int j = image.method_4307();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean bl;
            boolean bl2 = bl = i == 32;
            if (bl) {
                class_1011 nativeImage = new class_1011(64, 64, true);
                nativeImage.method_4317(image);
                image.close();
                image = nativeImage;
                nativeImage.method_4326(0, 32, 64, 32, 0);
                nativeImage.method_4304(4, 16, 16, 32, 4, 4, true, false);
                nativeImage.method_4304(8, 16, 16, 32, 4, 4, true, false);
                nativeImage.method_4304(0, 20, 24, 32, 4, 12, true, false);
                nativeImage.method_4304(4, 20, 16, 32, 4, 12, true, false);
                nativeImage.method_4304(8, 20, 8, 32, 4, 12, true, false);
                nativeImage.method_4304(12, 20, 16, 32, 4, 12, true, false);
                nativeImage.method_4304(44, 16, -8, 32, 4, 4, true, false);
                nativeImage.method_4304(48, 16, -8, 32, 4, 4, true, false);
                nativeImage.method_4304(40, 20, 0, 32, 4, 12, true, false);
                nativeImage.method_4304(44, 20, -8, 32, 4, 12, true, false);
                nativeImage.method_4304(48, 20, -16, 32, 4, 12, true, false);
                nativeImage.method_4304(52, 20, -8, 32, 4, 12, true, false);
            }
            PASSkinDownloader.stripAlpha(image, 0, 0, 32, 16);
            if (bl) {
                PASSkinDownloader.stripColor(image, 32, 0, 64, 32);
            }
            PASSkinDownloader.stripAlpha(image, 0, 16, 64, 32);
            PASSkinDownloader.stripAlpha(image, 16, 48, 48, 64);
            return image;
        }
        image.close();
        throw new IllegalStateException("Discarding incorrectly sized (" + j + "x" + i + ") skin texture: " + image.toString());
    }

    private static void stripColor(class_1011 image, int x1, int y1, int x2, int y2) {
        int j;
        int i;
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                int k = image.method_61940(i, j);
                if (class_9848.method_61320((int)k) >= 128) continue;
                return;
            }
        }
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                image.method_61941(i, j, image.method_61940(i, j) & 0xFFFFFF);
            }
        }
    }

    private static void stripAlpha(class_1011 image, int x1, int y1, int x2, int y2) {
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                image.method_61941(i, j, class_9848.method_61334((int)image.method_61940(i, j)));
            }
        }
    }
}

