/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.managers;

import com.danrus.pas.config.ModConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class OverlayMessageManger {
    private static final OverlayMessageManger INSTANCE = new OverlayMessageManger();

    public void showDownloadMessage(String name) {
        this.showMessage("pas.downloading", name, ChatFormatting.BLUE);
    }

    public void showInvalidNameMessage(String name) {
        this.showMessage("pas.invalid_username", name, ChatFormatting.RED);
    }

    public void showSuccessMessage(String name) {
        this.showMessage("pas.download_success", name, ChatFormatting.GREEN);
    }

    public void showFailMessage(String name) {
        this.showMessage("pas.download_failed", name, ChatFormatting.RED);
    }

    public void showOverlayNotFoundMessage(String name) {
    }

    private void showMessage(String key, String name, ChatFormatting color) {
        if (name.isEmpty()) {
            return;
        }
        switch (ModConfig.get().downloadStatusDisplay) {
            case NONE: {
                return;
            }
            case ABOVE_HOTBAR: {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)key, (Object[])new Object[]{name}).withStyle(color), false);
                return;
            }
            case CHAT: {
                Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)key, (Object[])new Object[]{name}).withStyle(color));
                return;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)ModConfig.get().downloadStatusDisplay));
    }

    public static OverlayMessageManger getInstance() {
        return INSTANCE;
    }
}

