/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.managers;

import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.TextureProvider;
import com.danrus.pas.api.TextureProvidersManager;
import com.danrus.pas.impl.providers.MojangSkinProvider;
import com.danrus.pas.impl.providers.NamemcSkinProvider;
import com.danrus.pas.managers.PasManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinProvidersManager
implements TextureProvidersManager {
    private static final String DEFAULT_LITERAL = "M";
    private static final String EXCLUDE_LITERALS = "NF";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SkinProvidersManagerImpl");
    private final Map<String, List<PrioritizedProvider>> providers = new HashMap<String, List<PrioritizedProvider>>();
    private final List<String> pendingList = new ArrayList<String>();

    public SkinProvidersManager() {
        this.addProvider(new MojangSkinProvider());
        this.addProvider(new NamemcSkinProvider());
    }

    @Override
    public void addProvider(TextureProvider provider) {
        this.addProvider(provider, 0);
    }

    @Override
    public void addProvider(TextureProvider provider, int priority) {
        this.providers.computeIfAbsent(provider.getLiteral(), k -> new ArrayList()).add(new PrioritizedProvider(provider, priority));
        this.providers.get(provider.getLiteral()).sort(Comparator.comparingInt(PrioritizedProvider::priority).reversed());
    }

    @Override
    public void download(NameInfo info) {
        if (this.pendingList.contains(info.base())) {
            return;
        }
        if (info.base().isEmpty()) {
            LOGGER.warn(this.getClass().getSimpleName() + ": Invalid input " + info.base());
            return;
        }
        boolean loaded = false;
        for (char c : EXCLUDE_LITERALS.toCharArray()) {
            if (info.params().indexOf(c) < 0 || !this.tryLoadFromProviders(String.valueOf(c), info)) continue;
            loaded = true;
            break;
        }
        if (!loaded) {
            Object object = this.providers.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String literal = (String)entry.getKey();
                if (EXCLUDE_LITERALS.contains(literal) || !info.params().contains(literal) || !this.tryLoad((List)entry.getValue(), info)) continue;
                loaded = true;
                break;
            }
        }
        if (!loaded && this.tryLoadFromProviders(DEFAULT_LITERAL, info)) {
            loaded = true;
        }
        if (!loaded) {
            LOGGER.error(this.getClass().getSimpleName() + ": No provider could load " + info.base() + " with params: " + info.params());
            PasManager.getInstance().getDataManager().invalidateData(info);
        }
    }

    private boolean tryLoadFromProviders(String literal, NameInfo info) {
        return this.tryLoad(this.providers.get(literal), info);
    }

    private boolean tryLoad(List<PrioritizedProvider> providerList, NameInfo info) {
        if (providerList == null || providerList.isEmpty()) {
            return false;
        }
        for (PrioritizedProvider prioritized : providerList) {
            try {
                LOGGER.info("Trying to download from {}", (Object)prioritized.provider.getClass().getSimpleName());
                this.pendingList.add(info.base());
                prioritized.provider().load(info, this.pendingList::remove);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Provider {} failed to load {}: {}", new Object[]{prioritized.provider().getClass().getSimpleName(), info.base(), e.getMessage()});
            }
        }
        return false;
    }

    private record PrioritizedProvider(TextureProvider provider, int priority) {
    }
}

