/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.api.info;

import com.danrus.pas.api.info.RenameFeature;
import com.danrus.pas.api.reg.FeatureRegistry;
import com.danrus.pas.impl.features.CapeFeature;
import com.danrus.pas.impl.features.OverlayFeature;
import com.danrus.pas.impl.features.SkinProviderFeature;
import com.danrus.pas.impl.features.SlimFeature;
import com.danrus.pas.utils.NIParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class NameInfo {
    private final Map<Class<? extends RenameFeature>, RenameFeature> features = new LinkedHashMap<Class<? extends RenameFeature>, RenameFeature>();
    private String base;
    public String legacyParams;

    public NameInfo() {
        this("");
    }

    public NameInfo(String base) {
        this.base = base == null ? "" : base;
        this.initializeFeatures();
    }

    private void initializeFeatures() {
        for (Class<? extends RenameFeature> featureClass : FeatureRegistry.getInstance().getOrderedFeatures()) {
            RenameFeature feature = FeatureRegistry.getInstance().createFeature(featureClass);
            if (feature == null) continue;
            this.features.put(featureClass, feature);
        }
    }

    public static NameInfo parse(class_2561 input) {
        if (input != null) {
            return NameInfo.parse(input.getString());
        }
        return new NameInfo();
    }

    public static NameInfo parse(String input) {
        return NIParser.getInstance().parse(input);
    }

    public String compile() {
        StringBuilder out = new StringBuilder();
        out.append(this.base == null ? "" : this.base);
        List featureParts = this.features.values().stream().map(RenameFeature::compile).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (this.legacyParams != null && !this.legacyParams.isEmpty()) {
            featureParts.add(0, this.legacyParams);
        }
        if (!featureParts.isEmpty()) {
            out.append("|").append(String.join((CharSequence)"", featureParts));
        }
        return out.toString();
    }

    public boolean isEmpty() {
        return this.base == null || this.base.isEmpty();
    }

    public <T extends RenameFeature> T getFeature(Class<T> featureClass) {
        return (T)this.features.get(featureClass);
    }

    public void setName(String newName) {
        this.base = newName == null ? "" : newName;
    }

    public String base() {
        return this.base;
    }

    public String legacyParams() {
        return this.legacyParams;
    }

    @NotNull
    public String toString() {
        return "NameInfo[" + this.compile() + "(" + this.hashCode() + ")]";
    }

    public int hashCode() {
        return this.base.hashCode() + this.getFeature(SkinProviderFeature.class).getProvider().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof NameInfo)) return false;
        NameInfo other = (NameInfo)obj;
        if (!Objects.equals(this.base, other.base)) return false;
        if (!Objects.equals(this.getFeature(SkinProviderFeature.class).getProvider(), other.getFeature(SkinProviderFeature.class).getProvider())) return false;
        return true;
    }

    @Deprecated
    public String getDesiredProvider() {
        SkinProviderFeature feature = this.getFeature(SkinProviderFeature.class);
        return feature != null ? feature.getProvider() : "M";
    }

    @Deprecated
    public boolean wantBeSlim() {
        SlimFeature feature = this.getFeature(SlimFeature.class);
        return feature != null && feature.isSlim();
    }

    @Deprecated
    public void setSlim(boolean slim) {
        SlimFeature feature = this.getFeature(SlimFeature.class);
        if (feature != null) {
            feature.setSlim(slim);
        }
    }

    @Deprecated
    public boolean wantCape() {
        CapeFeature feature = this.getFeature(CapeFeature.class);
        return feature != null && feature.isEnabled();
    }

    @Deprecated
    public void setCape(boolean cape) {
        CapeFeature feature = this.getFeature(CapeFeature.class);
        if (feature != null) {
            feature.setEnabled(cape);
        }
    }

    @Deprecated
    public void setOverlay(String texture) {
        OverlayFeature feature = this.getFeature(OverlayFeature.class);
        if (feature != null) {
            feature.setTexture(texture);
        }
    }

    @Deprecated
    public void setBlend(int blend) {
        OverlayFeature feature = this.getFeature(OverlayFeature.class);
        if (feature != null) {
            feature.setBlend(blend);
        }
    }

    @Deprecated
    public int blend() {
        OverlayFeature feature = this.getFeature(OverlayFeature.class);
        return feature != null ? feature.getBlend() : 100;
    }

    @Deprecated
    public String overlay() {
        OverlayFeature feature = this.getFeature(OverlayFeature.class);
        return feature != null ? feature.getTexture() : "";
    }

    @Deprecated
    public void setProvider(String provider) {
        SkinProviderFeature feature = this.getFeature(SkinProviderFeature.class);
        if (feature != null) {
            feature.setProvider(provider);
        }
    }

    @Deprecated
    public String capeProvider() {
        CapeFeature feature = this.getFeature(CapeFeature.class);
        return feature != null ? feature.getProvider() : "";
    }
}

