/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.providers.skin;

import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.api.reg.InfoTranslators;
import com.danrus.pas.impl.data.common.AbstractDiskDataProvider;
import com.danrus.pas.impl.holder.SkinData;
import com.danrus.pas.impl.providers.common.AbstractNamemcProvider;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.SkinDownloader;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;

public class NamemcSkinProvider
extends AbstractNamemcProvider<SkinData> {
    @Override
    protected CompletableFuture<class_2960> getDownloadTask(NameInfo info) {
        class_2960 location = InfoTranslators.getInstance().toResourceLocation(SkinData.class, info);
        String fileName = InfoTranslators.getInstance().toFileName(SkinData.class, info);
        Path filePath = AbstractDiskDataProvider.CACHE_PATH.resolve(fileName + ".png");
        return SkinDownloader.downloadAndRegister(location, filePath, "https://s.namemc.com/i/" + info.base() + ".png", true);
    }

    @Override
    protected DataRepository getDataManager() {
        return PasManager.getInstance().getSkinDataManager();
    }

    @Override
    protected SkinData createDataHolder(NameInfo info) {
        return new SkinData(info);
    }

    @Override
    protected void updateSkinData(NameInfo info, class_2960 texture) {
        SkinData data = (SkinData)this.getOrCreateDataHolder(info);
        data.setTexture(texture);
        this.getDataManager().store(info, data);
    }

    @Override
    protected SkinData getDataFromNamemcRepository(NameInfo info) {
        return PasManager.getInstance().getSkinDataManager().getSource("namemc").get(info);
    }

    @Override
    protected String getOutputString(NameInfo info) {
        return info.base();
    }
}

