/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.data.common;

import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.data.DataProvider;
import com.danrus.pas.api.data.DataStoreKey;
import com.danrus.pas.api.info.NameInfo;
import java.util.HashMap;

public abstract class AbstractCacheDataProvider<T extends DataHolder>
implements DataProvider<T> {
    protected final HashMap<DataStoreKey, T> cache = new HashMap();

    @Override
    public T get(NameInfo info) {
        DataStoreKey key = this.getKey(info);
        DataHolder value = (DataHolder)this.cache.get(key);
        if (value == null) {
            return null;
        }
        return (T)value;
    }

    @Override
    public T get(DataStoreKey key) {
        return (T)((DataHolder)this.cache.get(key));
    }

    @Override
    public boolean delete(NameInfo info) {
        DataStoreKey key = this.getKey(info);
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public HashMap<DataStoreKey, T> getAll() {
        return new HashMap<DataStoreKey, T>(this.cache);
    }

    @Override
    public void store(NameInfo info, T data) {
        this.cache.put(this.getKey(info), data);
    }

    @Override
    public void invalidateData(NameInfo info) {
        DataStoreKey key = this.getKey(info);
        DataHolder data = (DataHolder)this.cache.get(key);
        if (data != null) {
            data.setStatus(DownloadStatus.FAILED);
        } else {
            data = this.createDataHolder(info);
            data.setStatus(DownloadStatus.FAILED);
            this.cache.put(key, data);
        }
    }

    protected abstract T createDataHolder(NameInfo var1);

    protected abstract DataStoreKey getKey(NameInfo var1);
}

