/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.features;

import com.danrus.pas.api.info.RenameFeature;
import com.danrus.pas.managers.PasManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinProviderFeature
implements RenameFeature {
    private static final String DEFAULT_PROVIDER = "M";
    private String provider = "M";

    @Override
    public boolean parse(@NotNull String input) {
        List<String> providers = PasManager.getInstance().getExistingProviders();
        for (String prov : providers) {
            if (!input.contains(prov)) continue;
            this.provider = prov;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String compile() {
        return this.provider != null && !this.provider.equals(DEFAULT_PROVIDER) ? this.provider : "";
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public void reset() {
        this.provider = DEFAULT_PROVIDER;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(@Nullable String provider) {
        this.provider = provider == null ? DEFAULT_PROVIDER : provider;
    }
}

