/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.impl.features.CapeFeature;
import com.danrus.pas.impl.features.OverlayFeature;
import com.danrus.pas.impl.holder.CapeData;
import com.danrus.pas.impl.holder.SkinData;
import com.danrus.pas.managers.OverlayMessageManger;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.EncodeUtils;
import com.danrus.pas.utils.Rl;
import com.danrus.pas.utils.VersioningUtils;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;

public class TextureUtils {
    private static final HashMap<String, ResourceLocation> overlayTextureCache = new HashMap();
    private static final List<String> notExistingOverlays = new ArrayList<String>();

    public static CompletableFuture<ResourceLocation> registerTexture(Path path, ResourceLocation identifier, boolean remap) {
        NativeImage image = TextureUtils.parseImageFile(path);
        if (image != null) {
            return TextureUtils.registerTexture(image, identifier, remap);
        }
        return CompletableFuture.completedFuture(MissingTextureAtlasSprite.getLocation());
    }

    public static void clearOverlayCacheFor(String baseName) {
        overlayTextureCache.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(baseName + "_"));
    }

    public static CompletableFuture<ResourceLocation> registerTexture(NativeImage image, ResourceLocation identifier, boolean remap) {
        CompletableFuture<ResourceLocation> future = new CompletableFuture<ResourceLocation>();
        try {
            if (remap) {
                image = TextureUtils.remapTexture(image);
            }
            NativeImage finalImage = image;
            Minecraft.getInstance().execute(() -> {
                try {
                    DynamicTexture texture = new DynamicTexture(finalImage);
                    Minecraft.getInstance().getTextureManager().register(identifier, (AbstractTexture)texture);
                    future.complete(identifier);
                }
                catch (Exception e) {
                    future.complete(SkinData.DEFAULT_TEXTURE);
                    PlayerArmorStandsClient.LOGGER.warn("Failed to register texture: {}", (Object)identifier, (Object)e);
                }
            });
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.warn("Failed to process texture: {}", (Object)identifier, (Object)e);
            future.complete(SkinData.DEFAULT_TEXTURE);
        }
        return future;
    }

    public static void unregisterTexture(ResourceLocation identifier) {
        Minecraft.getInstance().getTextureManager().release(identifier);
        overlayTextureCache.remove(identifier.toString());
    }

    public static NativeImage parseImageFile(Path path) {
        NativeImage nativeImage;
        block8: {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                nativeImage = NativeImage.read((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    PlayerArmorStandsClient.LOGGER.warn("Failed to read texture from path: {}", (Object)path.toFile().getName(), (Object)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return nativeImage;
    }

    public static NativeImage getNativeImage(ResourceLocation identifier) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(identifier);
        if (texture instanceof DynamicTexture) {
            DynamicTexture nativeImageBackedTexture = (DynamicTexture)texture;
            return nativeImageBackedTexture.getPixels();
        }
        if (texture instanceof SimpleTexture) {
            SimpleTexture resourceTexture = (SimpleTexture)texture;
            try {
                return resourceTexture.loadContents(Minecraft.getInstance().getResourceManager()).image();
            }
            catch (Exception e) {
                PlayerArmorStandsClient.LOGGER.error("Failed to load texture image for: {}", (Object)identifier, (Object)e);
                PlayerArmorStandsClient.LOGGER.error("Unknown texture type: {}", (Object)texture.getClass().getName());
            }
        }
        return null;
    }

    public static void SaveImage(ResourceLocation identifier, Path path) {
        NativeImage image = TextureUtils.getNativeImage(identifier);
        if (image != null) {
            TextureUtils.SaveImage(image, path);
        }
    }

    public static void SaveImage(NativeImage image, Path path) {
        try {
            image.writeToFile(path.toFile());
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.warn("Failed to save texture to path: {}", (Object)path.toFile().getName(), (Object)e);
        }
    }

    private static NativeImage generateSkinProfile(NativeImage image) {
        NativeImage newImage = new NativeImage(16, 16, true);
        int i = image.getHeight();
        int j = image.getWidth();
        if (j == 64 && (i == 32 || i == 64)) {
            newImage.copyRect(image, 8, 8, 4, 2, 8, 8, false, false);
        }
        return newImage;
    }

    private static NativeImage remapTexture(NativeImage image) {
        int i = image.getHeight();
        int j = image.getWidth();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean bl;
            boolean bl2 = bl = i == 32;
            if (bl) {
                NativeImage nativeImage = new NativeImage(64, 64, true);
                nativeImage.copyFrom(image);
                image.close();
                image = nativeImage;
                nativeImage.fillRect(0, 32, 64, 32, 0);
                nativeImage.copyRect(4, 16, 16, 32, 4, 4, true, false);
                nativeImage.copyRect(8, 16, 16, 32, 4, 4, true, false);
                nativeImage.copyRect(0, 20, 24, 32, 4, 12, true, false);
                nativeImage.copyRect(4, 20, 16, 32, 4, 12, true, false);
                nativeImage.copyRect(8, 20, 8, 32, 4, 12, true, false);
                nativeImage.copyRect(12, 20, 16, 32, 4, 12, true, false);
                nativeImage.copyRect(44, 16, -8, 32, 4, 4, true, false);
                nativeImage.copyRect(48, 16, -8, 32, 4, 4, true, false);
                nativeImage.copyRect(40, 20, 0, 32, 4, 12, true, false);
                nativeImage.copyRect(44, 20, -8, 32, 4, 12, true, false);
                nativeImage.copyRect(48, 20, -16, 32, 4, 12, true, false);
                nativeImage.copyRect(52, 20, -8, 32, 4, 12, true, false);
            }
            TextureUtils.stripAlpha(image, 0, 0, 32, 16);
            if (bl) {
                TextureUtils.stripColor(image, 32, 0, 64, 32);
            }
            TextureUtils.stripAlpha(image, 0, 16, 64, 32);
            TextureUtils.stripAlpha(image, 16, 48, 48, 64);
            return image;
        }
        image.close();
        return null;
    }

    public static ResourceLocation getOverlayedTexture(NameInfo info, Class<? extends DataHolder> holderType) {
        OverlayFeature feature = info.getFeature(OverlayFeature.class);
        if (!feature.isEnabled()) {
            if (holderType == CapeData.class) {
                return PasManager.getInstance().getCapeTexture(info);
            }
            if (holderType == SkinData.class) {
                return PasManager.getInstance().getSkinTexture(info);
            }
        }
        if (holderType == CapeData.class) {
            CapeFeature capeFeature = info.getFeature(CapeFeature.class);
            return TextureUtils.getOverlayTexture(info, feature.getTexture(), "capes", feature.getBlend());
        }
        if (holderType == SkinData.class) {
            return TextureUtils.getOverlayTexture(info, feature.getTexture(), "skins", feature.getBlend());
        }
        throw new IllegalArgumentException("Unsupported holder type for overlayed texture: " + String.valueOf(holderType));
    }

    public static ResourceLocation getOverlayTexture(NameInfo info, String overlay, String prefix, int blendStrength) {
        String cacheKey = info.base() + "_" + overlay + "_" + blendStrength + "_" + prefix;
        if (notExistingOverlays.contains(overlay)) {
            if (prefix.equals("capes")) {
                return PasManager.getInstance().getCapeTexture(info);
            }
            return PasManager.getInstance().getSkinTexture(info);
        }
        ResourceLocation cachedTexture = overlayTextureCache.get(cacheKey);
        if (cachedTexture != null) {
            return cachedTexture;
        }
        ResourceLocation skinId = prefix.equals("capes") ? PasManager.getInstance().getCapeTexture(info) : PasManager.getInstance().getSkinTexture(info);
        AbstractTexture skinTexture = Minecraft.getInstance().getTextureManager().getTexture(skinId);
        ResourceLocation overlayId = Rl.vanilla("textures/block/" + overlay + ".png");
        AbstractTexture overlayTexture = Minecraft.getInstance().getTextureManager().getTexture(overlayId);
        if (overlayTexture == null) {
            OverlayMessageManger.getInstance().showOverlayNotFoundMessage(overlay);
            notExistingOverlays.add(overlay);
            return skinId;
        }
        try {
            if (skinTexture instanceof DynamicTexture) {
                DynamicTexture skinResourceTexture = (DynamicTexture)skinTexture;
                if (overlayTexture instanceof SimpleTexture) {
                    SimpleTexture overlayResourceTexture = (SimpleTexture)overlayTexture;
                    NativeImage skinImage = skinResourceTexture.getPixels();
                    NativeImage overlayImage = overlayResourceTexture.loadContents(Minecraft.getInstance().getResourceManager()).image();
                    NativeImage finalImage = TextureUtils.grayscaleSkinOverMaterial(skinImage, overlayImage, (float)blendStrength / 100.0f);
                    ResourceLocation finalIdentifier = Rl.pas(prefix + "/" + EncodeUtils.encodeToSha256(info.base()) + "_" + overlay + "_" + blendStrength);
                    TextureUtils.registerTexture(finalImage, finalIdentifier, prefix == "skins");
                    overlayTextureCache.put(cacheKey, finalIdentifier);
                    return finalIdentifier;
                }
            }
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.warn("Failed to create overlay texture for: {} with overlay: {}", new Object[]{info, overlay, e});
            OverlayMessageManger.getInstance().showOverlayNotFoundMessage(overlay);
            notExistingOverlays.add(overlay);
        }
        return skinId;
    }

    public static NativeImage grayscaleSkinOverMaterial(NativeImage skin, NativeImage material, float blendStrength) {
        int width = skin.getWidth();
        int height = skin.getHeight();
        NativeImage result = new NativeImage(width, height, true);
        int matWidth = material.getWidth();
        int matHeight = material.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int skinArgb = VersioningUtils.getPixel(skin, x, y);
                int sa = skinArgb >> 24 & 0xFF;
                if (sa < 10) {
                    VersioningUtils.setPixel(result, x, y, 0);
                    continue;
                }
                int sr = skinArgb >> 16 & 0xFF;
                int sg = skinArgb >> 8 & 0xFF;
                int sb = skinArgb & 0xFF;
                float brightness = (float)(sr + sg + sb) / 765.0f;
                int mx = x % matWidth;
                int my = y % matHeight;
                int matArgb = VersioningUtils.getPixel(material, mx, my);
                int mr = matArgb >> 16 & 0xFF;
                int mg = matArgb >> 8 & 0xFF;
                int mb = matArgb & 0xFF;
                int r = (int)((float)mr * brightness * blendStrength + (float)sr * (1.0f - blendStrength));
                int g = (int)((float)mg * brightness * blendStrength + (float)sg * (1.0f - blendStrength));
                int b = (int)((float)mb * brightness * blendStrength + (float)sb * (1.0f - blendStrength));
                int resultArgb = sa << 24 | r << 16 | g << 8 | b;
                VersioningUtils.setPixel(result, x, y, resultArgb);
            }
        }
        return result;
    }

    private static void stripColor(NativeImage image, int x1, int y1, int x2, int y2) {
        int j;
        int i;
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                int k = VersioningUtils.getPixel(image, i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                VersioningUtils.setPixel(image, i, j, VersioningUtils.getPixel(image, i, j) & 0xFFFFFF);
            }
        }
    }

    private static void stripAlpha(NativeImage image, int x1, int y1, int x2, int y2) {
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                VersioningUtils.setPixel(image, i, j, VersioningUtils.getPixel(image, i, j) | 0xFF000000);
            }
        }
    }
}

