/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.gui;

import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.impl.data.skin.FileTextureSkinData;
import com.danrus.pas.impl.features.CapeFeature;
import com.danrus.pas.impl.features.DisplayNameFeature;
import com.danrus.pas.render.gui.ArmorStandNamerAdapter;
import com.danrus.pas.render.gui.tabs.Tab;
import com.danrus.pas.render.gui.tabs.TabManager;
import com.danrus.pas.render.gui.widgets.ButtonWithIcon;
import com.danrus.pas.render.gui.widgets.EnterEditBox;
import com.danrus.pas.render.gui.widgets.PasSliderButtonImpl;
import com.danrus.pas.render.gui.widgets.TabButton;
import com.danrus.pas.render.gui.widgets.TextWidget;
import com.danrus.pas.utils.Rl;
import com.danrus.pas.utils.VersioningUtils;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_8666;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PasConfiguratorScreen
extends class_437 {
    public static final class_2960 BACKGROUND_TEXTURE = Rl.pas("pas_gui");
    public static final class_2960 MOJANG_LOGO = Rl.pas("mojang");
    public static final class_2960 NAMEMC_LOGO = Rl.pas("namemc");
    public static final class_2960 MCCAPES_LOGO = Rl.pas("minecraftcapes");
    public static final class_2960 FILE_LOGO = Rl.pas("file");
    public static final class_2960 WIDE_ARM_LOGO = Rl.pas("wide");
    public static final class_2960 SLIM_ARM_LOGO = Rl.pas("slim");
    public static final class_2960 YES_LOGO = Rl.pas("yes");
    public static final class_2960 NO_LOGO = Rl.pas("no");
    private static final float ANIMATION_SPEED = 0.5f;
    private float currentRotation = 0.0f;
    private float targetRotation = 0.0f;
    private float currentHeadX = 0.0f;
    private float currentHeadY = 0.0f;
    private float currentHeadZ = 0.0f;
    private float targetHeadX = 0.0f;
    private float targetHeadY = 0.0f;
    private float targetHeadZ = 0.0f;
    private boolean isAnimating = false;
    private AnimationState currentAnimationState = AnimationState.IDLE;
    public final TabButton skinTabButton;
    public final TabButton capeTabButton;
    public final TabButton overlayTabButton;
    private final class_4185 acceptButton;
    private final class_4185 cancelButton;
    private final class_1531 entity;
    private final ArmorStandNamerAdapter parent;
    private final ButtonWithIcon skinProviderButton;
    private final ButtonWithIcon armTypeButton;
    private final ButtonWithIcon armTypeButton2;
    private final TextWidget openFolderLabel;
    private final class_4185 openFolderButton;
    private final ButtonWithIcon capeAciveButton;
    private final ButtonWithIcon capeProviderButton;
    private NameInfo info;
    private final TabManager tabManager;

    public PasConfiguratorScreen(ArmorStandNamerAdapter parent) {
        super((class_2561)class_2561.method_43470((String)"Player Armor Stand Configurator"));
        this.parent = parent;
        this.entity = new class_1531((class_1937)class_310.method_1551().field_1687, 0.0, 0.0, 0.0);
        this.info = NameInfo.parse(parent.getNameInputValue());
        this.setEntityName(this.info.compile());
        this.acceptButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pas.menu.accept").method_27692(class_124.field_1060), b -> this.acceptName()).method_46434(this.field_22789, this.field_22790 / 2 - 110, 100, 20).method_46431();
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pas.menu.cancel").method_27692(class_124.field_1061), b -> class_310.method_1551().method_1507(parent.getScreen())).method_46434(this.field_22789, this.field_22790 / 2 + 110, 100, 20).method_46431();
        this.skinTabButton = new TabButton(5, 5, 80, 15, (class_2561)class_2561.method_43471((String)"pas.menu.tab.skin"));
        this.capeTabButton = new TabButton(105, 5, 80, 15, (class_2561)class_2561.method_43471((String)"pas.menu.tab.cape"));
        this.overlayTabButton = new TabButton(205, 5, 80, 15, (class_2561)class_2561.method_43471((String)"pas.menu.tab.overlay"));
        this.skinProviderButton = new ButtonWithIcon(0, 0, 120, 20, MOJANG_LOGO, (class_2561)class_2561.method_43471((String)("pas.menu.tab.skin.provider." + this.info.getDesiredProvider().toLowerCase())), button -> this.changeSkinProvider(this.info.getDesiredProvider(), button));
        this.armTypeButton = new ButtonWithIcon(0, 0, 120, 20, this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO, (class_2561)class_2561.method_43471((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))), button -> {
            this.info.setSlim(!this.info.wantBeSlim());
            ((ButtonWithIcon)button).icon = this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO;
            button.method_25355((class_2561)class_2561.method_43471((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))));
            this.setEntityName(this.info.compile());
        });
        this.armTypeButton2 = new ButtonWithIcon(0, 0, 120, 20, this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO, (class_2561)class_2561.method_43471((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))), button -> {
            this.info.setSlim(!this.info.wantBeSlim());
            ((ButtonWithIcon)button).icon = this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO;
            button.method_25355((class_2561)class_2561.method_43471((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))));
            this.setEntityName(this.info.compile());
        });
        this.capeProviderButton = new ButtonWithIcon(0, 0, 120, 20, MOJANG_LOGO, (class_2561)class_2561.method_43471((String)("pas.menu.tab.cape.provider." + this.info.getFeature(CapeFeature.class).getProvider().toLowerCase())), button -> {
            CapeFeature capeFeature = this.info.getFeature(CapeFeature.class);
            switch (capeFeature.getProvider()) {
                case "M": {
                    capeFeature.setProvider("A");
                    button.method_25355((class_2561)class_2561.method_43471((String)"pas.menu.tab.cape.provider.a"));
                    break;
                }
                case "A": {
                    capeFeature.setProvider("I");
                    button.method_25355((class_2561)class_2561.method_43471((String)"pas.menu.tab.cape.provider.i"));
                    break;
                }
                case "I": {
                    capeFeature.setProvider("M");
                    button.method_25355((class_2561)class_2561.method_43471((String)"pas.menu.tab.cape.provider.m"));
                }
            }
            this.setEntityName(this.info.compile());
        });
        this.capeAciveButton = new ButtonWithIcon(0, 0, 120, 20, this.info.wantCape() ? YES_LOGO : NO_LOGO, (class_2561)(this.info.wantCape() ? class_2561.method_43471((String)"pas.menu.tab.cape.yes") : class_2561.method_43471((String)"pas.menu.tab.cape.no")), button -> {
            this.info.setCape(!this.info.wantCape());
            ((ButtonWithIcon)button).icon = this.info.wantCape() ? YES_LOGO : NO_LOGO;
            button.method_25355((class_2561)class_2561.method_43471((String)("pas.menu.tab.cape." + (this.info.wantCape() ? "yes" : "no"))));
            this.setEntityName(this.info.compile());
        });
        this.openFolderLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.open_folder"));
        this.openFolderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.open_folder.button"), button -> {
            FileTextureSkinData.SKINS_PATH.toFile().mkdirs();
            class_156.method_668().method_672(FileTextureSkinData.SKINS_PATH.toFile());
        }).method_46434(0, 0, 120, 20).method_46431();
        this.tabManager = new TabManager(this);
        this.setupTabs();
    }

    private void setupTabs() {
        EnterEditBox nameBox = new EnterEditBox(class_310.method_1551().field_1772, 0, 0, 100, 20, (class_2561)class_2561.method_43470((String)"Name"), editBox -> {
            this.info.setName(editBox.method_1882());
            this.setEntityName(this.info.compile());
        });
        nameBox.method_1852(this.info.base());
        TextWidget nameLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.name")).setTooltip((class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.name.tooltip"));
        class_344 acceptNameButton = new class_344(0, 0, 20, 20, new class_8666(Rl.pas("accept"), Rl.pas("accept_disabled"), Rl.pas("accept_highlighted")), button -> {
            this.info.setName(nameBox.method_1882());
            this.setEntityName(this.info.compile());
        });
        TextWidget skinProviderLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.provider"));
        TextWidget armTypeLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.arm_type"));
        Tab skinTab = new Tab("skin", (width, height) -> {
            nameLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 87.0f));
            nameBox.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            acceptNameButton.method_48229(Math.round((float)width.intValue() / 2.0f + 92.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            skinProviderLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            this.skinProviderButton.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            armTypeLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 10.0f));
            this.armTypeButton.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 10.0f));
            this.openFolderLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f + 30.0f));
            this.openFolderButton.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 50.0f));
        });
        skinTab.addWidget((class_339)nameBox);
        skinTab.addWidget(nameLabel);
        skinTab.addWidget((class_339)acceptNameButton);
        skinTab.addWidget(skinProviderLabel);
        skinTab.addWidget((class_339)this.skinProviderButton);
        skinTab.addWidget(armTypeLabel);
        skinTab.addWidget((class_339)this.armTypeButton);
        skinTab.addWidget(this.openFolderLabel);
        skinTab.addWidget((class_339)this.openFolderButton);
        TextWidget capeActiveLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.cape.label"));
        TextWidget capeProviderLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.cape.provider"));
        TextWidget capeNameLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.cape.name")).setTooltip((class_2561)class_2561.method_43471((String)"pas.menu.tab.cape.name.tooltip"));
        TextWidget armTypeLabel2 = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.arm_type"));
        EnterEditBox capeNameBox = new EnterEditBox(class_310.method_1551().field_1772, 0, 0, 100, 20, (class_2561)class_2561.method_43470((String)"Cape Name"), editBox -> {
            CapeFeature capeFeature = this.info.getFeature(CapeFeature.class);
            capeFeature.setId(editBox.method_1882());
            this.setEntityName(this.info.compile());
        });
        capeNameBox.method_1852(this.info.getFeature(CapeFeature.class).getId());
        class_344 acceptCapeButton = new class_344(0, 0, 20, 20, new class_8666(Rl.pas("accept"), Rl.pas("accept_disabled"), Rl.pas("accept_highlighted")), button -> {
            this.info.getFeature(CapeFeature.class).setId(capeNameBox.method_1882());
            this.setEntityName(this.info.compile());
        });
        Tab capeTab = new Tab("cape", (width, height) -> {
            capeActiveLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 87.0f));
            this.capeAciveButton.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            armTypeLabel2.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            this.armTypeButton2.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            capeProviderLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 10.0f));
            this.capeProviderButton.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 10.0f));
            capeNameLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f + 30.0f));
            capeNameBox.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 50.0f));
            armTypeLabel2.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            this.armTypeButton2.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            acceptCapeButton.method_48229(Math.round((float)width.intValue() / 2.0f + 92.0f), Math.round((float)height.intValue() / 2.0f + 50.0f));
        });
        capeTab.addWidget(capeActiveLabel);
        capeTab.addWidget((class_339)this.capeAciveButton);
        capeTab.addWidget(armTypeLabel2);
        capeTab.addWidget((class_339)this.armTypeButton2);
        capeTab.addWidget(capeProviderLabel);
        capeTab.addWidget((class_339)this.capeProviderButton);
        capeTab.addWidget(capeNameLabel);
        capeTab.addWidget((class_339)capeNameBox);
        capeTab.addWidget((class_339)acceptCapeButton);
        TextWidget blockTextureNameLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.overlay.name")).setTooltip((class_2561)class_2561.method_43471((String)"pas.menu.tab.overlay.name.tooltip"));
        EnterEditBox blockTextureNameBox = new EnterEditBox(class_310.method_1551().field_1772, 0, 0, 100, 20, (class_2561)class_2561.method_43470((String)"Overlay Name"), editBox -> {
            this.info.setOverlay(editBox.method_1882());
            this.info.setBlend(Math.max(0, Math.min(100, this.info.blend())));
            this.setEntityName(this.info.compile());
        });
        PasSliderButtonImpl overlayBlendSlider = new PasSliderButtonImpl(0, 0, 120, 20, (class_2561)class_2561.method_43470((String)(this.info.blend() + "%")), this.info.blend(), i -> this.info.setBlend((int)i));
        class_344 acceptOverlayNameButton = new class_344(0, 0, 20, 20, new class_8666(Rl.pas("accept"), Rl.pas("accept_disabled"), Rl.pas("accept_highlighted")), button -> {
            this.info.setOverlay(blockTextureNameBox.method_1882());
            this.info.setBlend(Math.max(0, Math.min(100, this.info.blend())));
            this.setEntityName(this.info.compile());
        });
        TextWidget displayNameLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.overlay.display_name")).setTooltip((class_2561)class_2561.method_43471((String)"pas.menu.tab.overlay.display_name.tooltip"));
        EnterEditBox displayNameBox = new EnterEditBox(class_310.method_1551().field_1772, 0, 0, 120, 20, (class_2561)class_2561.method_43470((String)"Display Name"), editBox -> {
            DisplayNameFeature feature = this.info.getFeature(DisplayNameFeature.class);
            if (feature != null) {
                feature.setEnabled(!editBox.method_1882().isEmpty());
                feature.setName(editBox.method_1882());
                this.setEntityName(this.info.compile());
            }
        });
        blockTextureNameBox.method_1852(this.info.overlay());
        DisplayNameFeature displayNameFeature = this.info.getFeature(DisplayNameFeature.class);
        if (displayNameFeature != null && displayNameFeature.isEnabled()) {
            displayNameBox.method_1852(displayNameFeature.getName());
        }
        TextWidget blockTextureBlendLabel = new TextWidget(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"pas.menu.tab.overlay.blend"));
        Tab overlayTab = new Tab("overlay", (width, height) -> {
            blockTextureNameLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 87.0f));
            blockTextureNameBox.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            acceptOverlayNameButton.method_48229(Math.round((float)width.intValue() / 2.0f + 92.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            blockTextureBlendLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            overlayBlendSlider.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            displayNameLabel.method_48229(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 10.0f));
            displayNameBox.method_48229(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 10.0f));
        });
        overlayTab.addWidget(blockTextureNameLabel);
        overlayTab.addWidget((class_339)blockTextureNameBox);
        overlayTab.addWidget((class_339)acceptOverlayNameButton);
        overlayTab.addWidget(blockTextureBlendLabel);
        overlayTab.addWidget((class_339)overlayBlendSlider);
        overlayTab.addWidget(displayNameLabel);
        overlayTab.addWidget((class_339)displayNameBox);
        this.tabManager.addTab(this.skinTabButton, skinTab);
        this.tabManager.addTab(this.capeTabButton, capeTab);
        this.tabManager.addTab(this.overlayTabButton, overlayTab);
    }

    protected void method_25426() {
        this.tabManager.init();
        this.method_37063((class_364)this.acceptButton);
        this.method_37063((class_364)this.cancelButton);
        this.repositionElements(this.field_22789, this.field_22790);
    }

    private void repositionElements(int width, int height) {
        this.method_37063((class_364)this.skinTabButton);
        this.method_37063((class_364)this.capeTabButton);
        this.method_37063((class_364)this.overlayTabButton);
        this.acceptButton.method_48229(width / 2 + 10, height / 2 + 120);
        this.cancelButton.method_48229(width / 2 - 110, height / 2 + 120);
        this.skinTabButton.method_48229(width / 2 - 124, height / 2 - 109);
        this.capeTabButton.method_48229(width / 2 - 43, height / 2 - 109);
        this.overlayTabButton.method_48229(width / 2 + 38, height / 2 - 109);
        this.tabManager.reposition(width, height);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.repositionElements(width, height);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 g, int mouseX, int mouseY, float partialTick) {
        super.method_25420(g, mouseX, mouseY, partialTick);
        g.method_52706(VersioningUtils.getGuiRender(), BACKGROUND_TEXTURE, this.field_22789 / 2 - 128, this.field_22790 / 2 - 128 + 18, 256, 256);
    }

    public void method_25393() {
        boolean showOpenFolder;
        super.method_25393();
        this.currentAnimationState = this.tabManager.getActiveTab().getName().equals("cape") ? AnimationState.CAPE : AnimationState.IDLE;
        this.openFolderButton.field_22764 = showOpenFolder = "F".equals(this.info.getDesiredProvider()) && this.tabManager.getActiveTab().getName().equals("skin");
        this.openFolderLabel.field_22764 = showOpenFolder;
        this.openFolderButton.field_22763 = showOpenFolder;
        this.openFolderLabel.field_22763 = showOpenFolder;
        this.animateRotation(this.currentAnimationState);
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        super.method_25394(g, mouseX, mouseY, partialTick);
        if (this.isAnimating) {
            this.currentRotation = this.lerp(this.currentRotation, this.targetRotation, 0.5f, partialTick);
            this.currentHeadX = this.lerp(this.currentHeadX, this.targetHeadX, 0.5f, partialTick);
            this.currentHeadY = this.lerp(this.currentHeadY, this.targetHeadY, 0.5f, partialTick);
            this.currentHeadZ = this.lerp(this.currentHeadZ, this.targetHeadZ, 0.5f, partialTick);
            if (Math.abs(this.currentRotation - this.targetRotation) < 0.01f) {
                this.isAnimating = false;
            }
        }
        if (this.info.getDesiredProvider().equals("M")) {
            this.skinProviderButton.icon = MOJANG_LOGO;
        } else if (this.info.getDesiredProvider().equals("N")) {
            this.skinProviderButton.icon = NAMEMC_LOGO;
        } else if (this.info.getDesiredProvider().equals("F")) {
            this.skinProviderButton.icon = FILE_LOGO;
        }
        if (this.info.getFeature(CapeFeature.class).getProvider().equals("M")) {
            this.capeProviderButton.icon = MOJANG_LOGO;
        } else if (this.info.getFeature(CapeFeature.class).getProvider().equals("A")) {
            this.capeProviderButton.icon = NAMEMC_LOGO;
        } else if (this.info.getFeature(CapeFeature.class).getProvider().equals("I")) {
            this.capeProviderButton.icon = MCCAPES_LOGO;
        }
        g.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"pas.menu.name"), this.field_22789 / 2, 15, 0xFFFFFF);
        this.entity.method_6919(new class_2379(this.currentHeadX, this.currentHeadY, this.currentHeadZ));
        Quaternionf rotation = new Quaternionf().rotateX(3.4557521f).rotateY((float)Math.toRadians(this.currentRotation + 30.0f));
        int left = this.field_22789 / 2 - 130;
        int top = this.field_22790 / 2 - 70;
        int right = this.field_22789 / 2 - 18;
        int bottom = this.field_22790 / 2 + 120;
        float scale = 70.0f;
        Vector3f translation = new Vector3f(0.1f, 0.75f, 0.0f);
        class_490.method_48472((class_332)g, (int)left, (int)top, (int)right, (int)bottom, (float)scale, (Vector3f)translation, (Quaternionf)rotation, null, (class_1309)this.entity);
    }

    private float lerp(float start, float end, float speed, float partialTick) {
        return start + (end - start) * speed * partialTick;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent.getScreen());
        this.acceptName();
    }

    private void setEntityName(String name) {
        if (name != null && !name.isEmpty()) {
            this.entity.method_5665((class_2561)class_2561.method_43470((String)name));
        } else {
            this.entity.method_5665(null);
        }
    }

    private void animateRotation(AnimationState state) {
        this.isAnimating = true;
        switch (state.ordinal()) {
            case 0: {
                this.targetRotation = 0.0f;
                this.targetHeadX = 0.0f;
                this.targetHeadY = 0.0f;
                this.targetHeadZ = 0.0f;
                break;
            }
            case 1: {
                this.targetRotation = 180.0f;
                this.targetHeadX = 10.0f;
                this.targetHeadY = -120.0f;
                this.targetHeadZ = 0.0f;
            }
        }
    }

    private void acceptName() {
        class_310.method_1551().method_1507(this.parent.getScreen());
        String toAnvil = this.info.compile();
        this.parent.setNameInputValue(toAnvil);
    }

    private void changeSkinProvider(String literal, class_4185 button) {
        switch (literal) {
            case "M": {
                this.info.setProvider("N");
                button.method_25355((class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.provider.n"));
                break;
            }
            case "N": {
                this.info.setProvider("F");
                button.method_25355((class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.provider.f"));
                break;
            }
            case "F": {
                this.info.setProvider("M");
                button.method_25355((class_2561)class_2561.method_43471((String)"pas.menu.tab.skin.provider.m"));
            }
        }
    }

    private static enum AnimationState {
        IDLE,
        CAPE;

    }
}

