/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.impl.features.CapeFeature;
import com.danrus.pas.impl.features.OverlayFeature;
import com.danrus.pas.impl.holder.CapeData;
import com.danrus.pas.impl.holder.SkinData;
import com.danrus.pas.managers.OverlayMessageManger;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.EncodeUtils;
import com.danrus.pas.utils.Rl;
import com.danrus.pas.utils.VersioningUtils;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class TextureUtils {
    private static final HashMap<String, class_2960> overlayTextureCache = new HashMap();
    private static final List<String> notExistingOverlays = new ArrayList<String>();

    public static CompletableFuture<class_2960> registerTexture(Path path, class_2960 identifier, boolean remap) {
        class_1011 image = TextureUtils.parseImageFile(path);
        if (image != null) {
            return TextureUtils.registerTexture(image, identifier, remap);
        }
        return CompletableFuture.completedFuture(class_1047.method_4539());
    }

    public static void clearOverlayCacheFor(String baseName) {
        overlayTextureCache.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(baseName + "_"));
    }

    public static CompletableFuture<class_2960> registerTexture(class_1011 image, class_2960 identifier, boolean remap) {
        CompletableFuture<class_2960> future = new CompletableFuture<class_2960>();
        try {
            if (remap) {
                image = TextureUtils.remapTexture(image);
            }
            class_1011 finalImage = image;
            class_310.method_1551().execute(() -> {
                try {
                    class_1043 texture = new class_1043(() -> ((class_2960)identifier).toString(), finalImage);
                    class_310.method_1551().method_1531().method_4616(identifier, (class_1044)texture);
                    future.complete(identifier);
                }
                catch (Exception e) {
                    future.complete(SkinData.DEFAULT_TEXTURE);
                    PlayerArmorStandsClient.LOGGER.warn("Failed to register texture: {}", (Object)identifier, (Object)e);
                }
            });
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.warn("Failed to process texture: {}", (Object)identifier, (Object)e);
            future.complete(SkinData.DEFAULT_TEXTURE);
        }
        return future;
    }

    public static void unregisterTexture(class_2960 identifier) {
        class_310.method_1551().method_1531().method_4615(identifier);
        overlayTextureCache.remove(identifier.toString());
    }

    public static class_1011 parseImageFile(Path path) {
        class_1011 class_10112;
        block8: {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                class_10112 = class_1011.method_4309((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    PlayerArmorStandsClient.LOGGER.warn("Failed to read texture from path: {}", (Object)path.toFile().getName(), (Object)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return class_10112;
    }

    public static class_1011 getNativeImage(class_2960 identifier) {
        class_1044 texture = class_310.method_1551().method_1531().method_4619(identifier);
        if (texture instanceof class_1043) {
            class_1043 nativeImageBackedTexture = (class_1043)texture;
            return nativeImageBackedTexture.method_4525();
        }
        if (texture instanceof class_1049) {
            class_1049 resourceTexture = (class_1049)texture;
            try {
                return resourceTexture.method_65809(class_310.method_1551().method_1478()).comp_3447();
            }
            catch (Exception e) {
                PlayerArmorStandsClient.LOGGER.error("Failed to load texture image for: {}", (Object)identifier, (Object)e);
                PlayerArmorStandsClient.LOGGER.error("Unknown texture type: {}", (Object)texture.getClass().getName());
            }
        }
        return null;
    }

    public static void SaveImage(class_2960 identifier, Path path) {
        class_1011 image = TextureUtils.getNativeImage(identifier);
        if (image != null) {
            TextureUtils.SaveImage(image, path);
        }
    }

    public static void SaveImage(class_1011 image, Path path) {
        try {
            image.method_4325(path.toFile());
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.warn("Failed to save texture to path: {}", (Object)path.toFile().getName(), (Object)e);
        }
    }

    private static class_1011 generateSkinProfile(class_1011 image) {
        class_1011 newImage = new class_1011(16, 16, true);
        int i = image.method_4323();
        int j = image.method_4307();
        if (j == 64 && (i == 32 || i == 64)) {
            newImage.method_47594(image, 8, 8, 4, 2, 8, 8, false, false);
        }
        return newImage;
    }

    private static class_1011 remapTexture(class_1011 image) {
        int i = image.method_4323();
        int j = image.method_4307();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean bl;
            boolean bl2 = bl = i == 32;
            if (bl) {
                class_1011 nativeImage = new class_1011(64, 64, true);
                nativeImage.method_4317(image);
                image.close();
                image = nativeImage;
                nativeImage.method_4326(0, 32, 64, 32, 0);
                nativeImage.method_4304(4, 16, 16, 32, 4, 4, true, false);
                nativeImage.method_4304(8, 16, 16, 32, 4, 4, true, false);
                nativeImage.method_4304(0, 20, 24, 32, 4, 12, true, false);
                nativeImage.method_4304(4, 20, 16, 32, 4, 12, true, false);
                nativeImage.method_4304(8, 20, 8, 32, 4, 12, true, false);
                nativeImage.method_4304(12, 20, 16, 32, 4, 12, true, false);
                nativeImage.method_4304(44, 16, -8, 32, 4, 4, true, false);
                nativeImage.method_4304(48, 16, -8, 32, 4, 4, true, false);
                nativeImage.method_4304(40, 20, 0, 32, 4, 12, true, false);
                nativeImage.method_4304(44, 20, -8, 32, 4, 12, true, false);
                nativeImage.method_4304(48, 20, -16, 32, 4, 12, true, false);
                nativeImage.method_4304(52, 20, -8, 32, 4, 12, true, false);
            }
            TextureUtils.stripAlpha(image, 0, 0, 32, 16);
            if (bl) {
                TextureUtils.stripColor(image, 32, 0, 64, 32);
            }
            TextureUtils.stripAlpha(image, 0, 16, 64, 32);
            TextureUtils.stripAlpha(image, 16, 48, 48, 64);
            return image;
        }
        image.close();
        return null;
    }

    public static class_2960 getOverlayedTexture(NameInfo info, Class<? extends DataHolder> holderType) {
        OverlayFeature feature = info.getFeature(OverlayFeature.class);
        if (!feature.isEnabled()) {
            if (holderType == CapeData.class) {
                return PasManager.getInstance().getCapeTexture(info);
            }
            if (holderType == SkinData.class) {
                return PasManager.getInstance().getSkinTexture(info);
            }
        }
        if (holderType == CapeData.class) {
            CapeFeature capeFeature = info.getFeature(CapeFeature.class);
            return TextureUtils.getOverlayTexture(info, feature.getTexture(), "capes", feature.getBlend());
        }
        if (holderType == SkinData.class) {
            return TextureUtils.getOverlayTexture(info, feature.getTexture(), "skins", feature.getBlend());
        }
        throw new IllegalArgumentException("Unsupported holder type for overlayed texture: " + String.valueOf(holderType));
    }

    public static class_2960 getOverlayTexture(NameInfo info, String overlay, String prefix, int blendStrength) {
        String cacheKey = info.base() + "_" + overlay + "_" + blendStrength + "_" + prefix;
        if (notExistingOverlays.contains(overlay)) {
            if (prefix.equals("capes")) {
                return PasManager.getInstance().getCapeTexture(info);
            }
            return PasManager.getInstance().getSkinTexture(info);
        }
        class_2960 cachedTexture = overlayTextureCache.get(cacheKey);
        if (cachedTexture != null) {
            return cachedTexture;
        }
        class_2960 skinId = prefix.equals("capes") ? PasManager.getInstance().getCapeTexture(info) : PasManager.getInstance().getSkinTexture(info);
        class_1044 skinTexture = class_310.method_1551().method_1531().method_4619(skinId);
        class_2960 overlayId = Rl.vanilla("textures/block/" + overlay + ".png");
        class_1044 overlayTexture = class_310.method_1551().method_1531().method_4619(overlayId);
        if (overlayTexture == null) {
            OverlayMessageManger.getInstance().showOverlayNotFoundMessage(overlay);
            notExistingOverlays.add(overlay);
            return skinId;
        }
        try {
            if (skinTexture instanceof class_1043) {
                class_1043 skinResourceTexture = (class_1043)skinTexture;
                if (overlayTexture instanceof class_1049) {
                    class_1049 overlayResourceTexture = (class_1049)overlayTexture;
                    class_1011 skinImage = skinResourceTexture.method_4525();
                    class_1011 overlayImage = overlayResourceTexture.method_65809(class_310.method_1551().method_1478()).comp_3447();
                    class_1011 finalImage = TextureUtils.grayscaleSkinOverMaterial(skinImage, overlayImage, (float)blendStrength / 100.0f);
                    class_2960 finalIdentifier = Rl.pas(prefix + "/" + EncodeUtils.encodeToSha256(info.base()) + "_" + overlay + "_" + blendStrength);
                    TextureUtils.registerTexture(finalImage, finalIdentifier, prefix == "skins");
                    overlayTextureCache.put(cacheKey, finalIdentifier);
                    return finalIdentifier;
                }
            }
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.warn("Failed to create overlay texture for: {} with overlay: {}", new Object[]{info, overlay, e});
            OverlayMessageManger.getInstance().showOverlayNotFoundMessage(overlay);
            notExistingOverlays.add(overlay);
        }
        return skinId;
    }

    public static class_1011 grayscaleSkinOverMaterial(class_1011 skin, class_1011 material, float blendStrength) {
        int width = skin.method_4307();
        int height = skin.method_4323();
        class_1011 result = new class_1011(width, height, true);
        int matWidth = material.method_4307();
        int matHeight = material.method_4323();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int skinArgb = VersioningUtils.getPixel(skin, x, y);
                int sa = skinArgb >> 24 & 0xFF;
                if (sa < 10) {
                    VersioningUtils.setPixel(result, x, y, 0);
                    continue;
                }
                int sr = skinArgb >> 16 & 0xFF;
                int sg = skinArgb >> 8 & 0xFF;
                int sb = skinArgb & 0xFF;
                float brightness = (float)(sr + sg + sb) / 765.0f;
                int mx = x % matWidth;
                int my = y % matHeight;
                int matArgb = VersioningUtils.getPixel(material, mx, my);
                int mr = matArgb >> 16 & 0xFF;
                int mg = matArgb >> 8 & 0xFF;
                int mb = matArgb & 0xFF;
                int r = (int)((float)mr * brightness * blendStrength + (float)sr * (1.0f - blendStrength));
                int g = (int)((float)mg * brightness * blendStrength + (float)sg * (1.0f - blendStrength));
                int b = (int)((float)mb * brightness * blendStrength + (float)sb * (1.0f - blendStrength));
                int resultArgb = sa << 24 | r << 16 | g << 8 | b;
                VersioningUtils.setPixel(result, x, y, resultArgb);
            }
        }
        return result;
    }

    private static void stripColor(class_1011 image, int x1, int y1, int x2, int y2) {
        int j;
        int i;
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                int k = VersioningUtils.getPixel(image, i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                VersioningUtils.setPixel(image, i, j, VersioningUtils.getPixel(image, i, j) & 0xFFFFFF);
            }
        }
    }

    private static void stripAlpha(class_1011 image, int x1, int y1, int x2, int y2) {
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                VersioningUtils.setPixel(image, i, j, VersioningUtils.getPixel(image, i, j) | 0xFF000000);
            }
        }
    }
}

