/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.providers;

import com.danrus.pas.ModExecutor;
import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.SkinData;
import com.danrus.pas.api.TextureProvider;
import com.danrus.pas.impl.data.NamemcDiskData;
import com.danrus.pas.managers.OverlayMessageManger;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.Rl;
import com.danrus.pas.utils.SkinDownloader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class NamemcSkinProvider
implements TextureProvider {
    private String literal = "N";
    private Consumer<String> onComplete;
    private String output;

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public void load(NameInfo info, Consumer<String> onComplete) {
        this.onComplete = onComplete;
        this.output = info.base();
        this.initializeDownload(info);
        ModExecutor.execute(() -> ((CompletableFuture)SkinDownloader.downloadAndRegister(Rl.pas("skins/" + info.base()), NamemcDiskData.CACHE_PATH.resolve(info.base() + "_namemc.png"), "https://s.namemc.com/i/" + info.base() + ".png", true).thenApply(identifier -> {
            this.updateStatus(info, DownloadStatus.COMPLETED);
            this.updateSkinData(info, (ResourceLocation)identifier, true);
            onComplete.accept(this.output);
            OverlayMessageManger.getInstance().showSuccessMessage(info.base());
            return null;
        })).exceptionally(throwable -> {
            this.doFail(info);
            PlayerArmorStandsClient.LOGGER.error("NamemcSkinProvider: Failed to download skin for " + String.valueOf(info), throwable);
            return null;
        }));
    }

    private void initializeDownload(NameInfo info) {
        PlayerArmorStandsClient.LOGGER.info("NamemcSkinProvider: Downloading skin for " + String.valueOf(info));
        SkinData data = new SkinData(info);
        OverlayMessageManger.getInstance().showDownloadMessage(info.base());
        data.setStatus(DownloadStatus.IN_PROGRESS);
        PasManager.getInstance().getDataManager().store(info, data);
    }

    private void updateStatus(NameInfo info, DownloadStatus status) {
        SkinData data = this.getOrCreateModelData(info);
        data.setStatus(status);
        PasManager.getInstance().getDataManager().store(info, data);
    }

    private void doFail(NameInfo info) {
        SkinData data = PasManager.getInstance().getData(info);
        if (data == null) {
            data = new SkinData(info);
        }
        OverlayMessageManger.getInstance().showFailMessage(info.base());
        data.setStatus(DownloadStatus.FAILED);
        PasManager.getInstance().getDataManager().store(info, data);
    }

    private void updateSkinData(NameInfo info, ResourceLocation texture, boolean isSkin) {
        SkinData data = this.getOrCreateModelData(info);
        if (isSkin) {
            data.setSkinTexture(texture);
        } else {
            data.setCapeTexture(texture);
        }
        PasManager.getInstance().getDataManager().store(info, data);
    }

    private SkinData getOrCreateModelData(NameInfo info) {
        SkinData data = PasManager.getInstance().getDataManager().getSource("namemc").get(info);
        return data != null ? data : new SkinData(info);
    }
}

