/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.armorstand;

import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.SkinData;
import com.danrus.pas.config.ModConfig;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.render.armorstand.ModelWithCape;
import com.danrus.pas.utils.VersioningUtils;
import java.util.List;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;

public class PlayerArmorStandModel
extends ArmorStandArmorModel
implements ModelWithCape {
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart leftSlimArm;
    public final ModelPart rightSlimArm;
    public final ModelPart leftSlimSleeve;
    public final ModelPart rightSlimSleeve;
    public final ModelPart rightBodyStick;
    public final ModelPart leftBodyStick;
    public final ModelPart shoulderStick;
    public final ModelPart basePlate;
    public final ModelPart originalHead;
    public final ModelPart originalBody;
    public final ModelPart originalRightArm;
    public final ModelPart originalLeftArm;
    public final ModelPart originalRightLeg;
    public final ModelPart originalLeftLeg;
    public final ModelPart jacket;
    private final ModelPart cloak;
    private final ModelPart leftEar;
    private final ModelPart rightEar;
    private SkinData data;
    private boolean isSlim = false;
    private boolean isOriginal = false;

    public PlayerArmorStandModel(ModelPart root) {
        super(root);
        this.cloak = root.getChild("cloak");
        this.leftSleeve = root.getChild("left_sleeve");
        this.rightSleeve = root.getChild("right_sleeve");
        this.leftPants = root.getChild("left_pants");
        this.rightPants = root.getChild("right_pants");
        this.jacket = root.getChild("jacket");
        this.leftSlimArm = root.getChild("left_slim_arm");
        this.rightSlimArm = root.getChild("right_slim_arm");
        this.leftSlimSleeve = root.getChild("left_slim_sleeve");
        this.rightSlimSleeve = root.getChild("right_slim_sleeve");
        this.rightBodyStick = root.getChild("right_body_stick");
        this.leftBodyStick = root.getChild("left_body_stick");
        this.shoulderStick = root.getChild("shoulder_stick");
        this.basePlate = root.getChild("base_plate");
        this.originalHead = root.getChild("original_head");
        this.originalBody = root.getChild("original_body");
        this.originalRightArm = root.getChild("original_right_arm");
        this.originalLeftArm = root.getChild("original_left_arm");
        this.originalRightLeg = root.getChild("original_right_leg");
        this.originalLeftLeg = root.getChild("original_left_leg");
        this.leftEar = this.head.getChild("left_ear");
        this.rightEar = this.head.getChild("right_ear");
        this.hat.visible = true;
        this.leftEar.visible = false;
        this.rightEar.visible = false;
        this.leftSleeve.visible = true;
        this.rightSleeve.visible = true;
        this.leftPants.visible = true;
        this.rightPants.visible = true;
        this.jacket.visible = true;
        this.rightBodyStick.visible = false;
        this.leftBodyStick.visible = false;
        this.shoulderStick.visible = false;
        this.basePlate.visible = false;
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("cloak", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, deformation, 1.0f, 0.5f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.extend(0.25f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_pants", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.extend(0.25f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_pants", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.extend(0.25f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation.extend(0.25f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_body_stick", CubeListBuilder.create().texOffs(16, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 7.0f, 1.0f, deformation), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_body_stick", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 7.0f, 1.0f, deformation), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shoulder_stick", CubeListBuilder.create().texOffs(0, 0).addBox(-6.5f, -0.5f, -0.5f, 13.0f, 1.0f, 1.0f, deformation), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("base_plate", CubeListBuilder.create().texOffs(0, 32).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 1.0f, 12.0f, deformation), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_slim_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_slim_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_slim_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, deformation.extend(0.25f)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_slim_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, deformation.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("original_head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("original_body", CubeListBuilder.create().texOffs(0, 26).addBox(-6.0f, 0.0f, -1.5f, 12.0f, 3.0f, 3.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("original_right_arm", CubeListBuilder.create().texOffs(24, 0).addBox(-2.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("original_left_arm", CubeListBuilder.create().texOffs(32, 16).mirror().addBox(0.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("original_right_leg", CubeListBuilder.create().texOffs(8, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("original_left_leg", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_body_stick", CubeListBuilder.create().texOffs(16, 0).addBox(-3.0f, 3.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_body_stick", CubeListBuilder.create().texOffs(48, 16).addBox(1.0f, 3.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("shoulder_stick", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, 10.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("base_plate", CubeListBuilder.create().texOffs(0, 32).addBox(-6.0f, 11.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition headDefinition = partdefinition.getChild("head");
        CubeListBuilder earsCubeListBuilder = CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, new CubeDeformation(1.0f));
        headDefinition.addOrReplaceChild("left_ear", earsCubeListBuilder, PartPose.offset((float)-6.0f, (float)-6.0f, (float)0.0f));
        headDefinition.addOrReplaceChild("right_ear", earsCubeListBuilder, PartPose.offset((float)6.0f, (float)-6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(ArmorStandRenderState armorStand) {
        boolean isEarsVisible;
        super.setupAnim(armorStand);
        boolean showBase = !VersioningUtils.getNoBasePlate(armorStand);
        boolean showArms = VersioningUtils.getIsShowArms(armorStand);
        Component customName = VersioningUtils.getCustomName(armorStand);
        Rotations bodyPose = VersioningUtils.getBodyPose(armorStand);
        NameInfo info = NameInfo.parse(customName);
        this.data = PasManager.getInstance().getData(info);
        PlayerArmorStandModel.cpp(this.leftLeg, this.leftPants);
        PlayerArmorStandModel.cpp(this.rightLeg, this.rightPants);
        PlayerArmorStandModel.cpp(this.leftArm, this.leftSleeve);
        PlayerArmorStandModel.cpp(this.rightArm, this.rightSleeve);
        PlayerArmorStandModel.cpp(this.leftArm, this.leftSlimArm);
        PlayerArmorStandModel.cpp(this.rightArm, this.rightSlimArm);
        PlayerArmorStandModel.cpp(this.leftArm, this.leftSlimSleeve);
        PlayerArmorStandModel.cpp(this.rightArm, this.rightSlimSleeve);
        PlayerArmorStandModel.cpp(this.body, this.originalBody);
        PlayerArmorStandModel.cpp(this.head, this.originalHead);
        PlayerArmorStandModel.cpp(this.rightArm, this.originalRightArm);
        PlayerArmorStandModel.cpp(this.leftArm, this.originalLeftArm);
        PlayerArmorStandModel.cpp(this.rightLeg, this.originalRightLeg);
        PlayerArmorStandModel.cpp(this.leftLeg, this.originalLeftLeg);
        PlayerArmorStandModel.cpp(this.body, this.jacket);
        this.basePlate.yRot = (float)Math.PI / 180 * -VersioningUtils.getYRot(armorStand);
        if (!ModConfig.get().enableMod) {
            this.setOriginalAngles(showBase, showArms, bodyPose);
            return;
        }
        String customNameString = !ModConfig.get().defaultSkin.isEmpty() && customName == null ? ModConfig.get().defaultSkin : (customName != null ? customName.getString() : "");
        this.leftEar.visible = isEarsVisible = "deadmau5".equals(info.base()) && ModConfig.get().showEasterEggs;
        this.rightEar.visible = isEarsVisible;
        this.setModelVisibility(!PlayerArmorStandModel.showArmorStandWhileDownload(customName, this.data), info.wantBeSlim(), showBase);
        if (customNameString.isEmpty() && ModConfig.get().defaultSkin.isEmpty()) {
            this.setOriginalAngles(showBase, showArms, bodyPose);
        }
    }

    public Iterable<ModelPart> bodyParts() {
        return List.of(this.hat, this.head, this.body, this.jacket, this.leftArm, this.rightArm, this.leftSleeve, this.rightSleeve, this.leftPants, this.rightPants, this.leftLeg, this.rightLeg, this.leftSlimArm, this.rightSlimArm, this.leftSlimSleeve, this.rightSlimSleeve, this.originalHead, this.originalBody, this.originalRightArm, this.originalLeftArm, this.originalRightLeg, this.originalLeftLeg, this.rightBodyStick, this.leftBodyStick, this.shoulderStick, this.basePlate);
    }

    public Iterable<ModelPart> headParts() {
        return List.of(this.hat, this.head, this.originalHead, this.leftEar, this.rightEar);
    }

    private void setModelVisibility(boolean player, boolean slim, boolean showBase) {
        this.hat.visible = player;
        this.head.visible = player;
        this.body.visible = player;
        this.jacket.visible = player;
        this.leftArm.visible = player && !slim;
        this.rightArm.visible = player && !slim;
        this.leftSleeve.visible = player && !slim;
        this.rightSleeve.visible = player && !slim;
        this.leftPants.visible = player;
        this.rightPants.visible = player;
        this.leftLeg.visible = player;
        this.rightLeg.visible = player;
        this.leftSlimArm.visible = player && slim;
        this.rightSlimArm.visible = player && slim;
        this.leftSlimSleeve.visible = player && slim;
        this.rightSlimSleeve.visible = player && slim;
        this.originalHead.visible = !player;
        this.originalBody.visible = !player;
        this.originalRightArm.visible = !player;
        this.originalLeftArm.visible = !player;
        this.originalRightLeg.visible = !player;
        this.originalLeftLeg.visible = !player;
        this.rightBodyStick.visible = !player;
        this.leftBodyStick.visible = !player;
        this.shoulderStick.visible = !player;
        this.basePlate.visible = showBase && !player;
        this.cloak.visible = false;
    }

    private void setOriginalAngles(boolean showBase, boolean showArms, Rotations bodyPose) {
        this.setModelVisibility(false, false, showBase);
        this.originalLeftArm.visible = showArms;
        this.originalRightArm.visible = showArms;
        this.rightBodyStick.xRot = (float)Math.PI / 180 * VersioningUtils.getXRot(bodyPose);
        this.rightBodyStick.yRot = (float)Math.PI / 180 * VersioningUtils.getYRot(bodyPose);
        this.rightBodyStick.zRot = (float)Math.PI / 180 * VersioningUtils.getZRot(bodyPose);
        this.leftBodyStick.xRot = (float)Math.PI / 180 * VersioningUtils.getXRot(bodyPose);
        this.leftBodyStick.yRot = (float)Math.PI / 180 * VersioningUtils.getYRot(bodyPose);
        this.leftBodyStick.zRot = (float)Math.PI / 180 * VersioningUtils.getZRot(bodyPose);
        this.shoulderStick.xRot = (float)Math.PI / 180 * VersioningUtils.getXRot(bodyPose);
        this.shoulderStick.yRot = (float)Math.PI / 180 * VersioningUtils.getYRot(bodyPose);
        this.shoulderStick.zRot = (float)Math.PI / 180 * VersioningUtils.getZRot(bodyPose);
    }

    @Override
    public ModelPart getCape() {
        return this.cloak;
    }

    @Override
    public SkinData getData() {
        return this.data;
    }

    public static boolean showArmorStandWhileDownload(Component customName, SkinData data) {
        boolean isDownlading = data.getStatus() == DownloadStatus.IN_PROGRESS || data.getStatus() == DownloadStatus.FAILED;
        return ModConfig.get().showArmorStandWhileDownloading && isDownlading;
    }

    private static void cpp(ModelPart from, ModelPart to) {
        VersioningUtils.copyPartPose(from, to);
    }
}

