/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.data.common;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.data.DataProvider;
import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.data.DataStoreKey;
import com.danrus.pas.api.data.TextureProvidersManager;
import com.danrus.pas.api.info.NameInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataRepository<T extends DataHolder>
implements DataRepository<T> {
    private final List<DataProvider<T>> sources = new CopyOnWriteArrayList<DataProvider<T>>();

    public AbstractDataRepository() {
        this.prepareSources();
    }

    @Override
    public void addSource(DataProvider<T> source) {
        this.sources.add(source);
    }

    @Override
    public void addSource(DataProvider<T> source, int priority) {
        if (priority < 0) {
            throw new IllegalArgumentException("Priority cannot be negative");
        }
        if (priority >= this.sources.size()) {
            this.sources.add(source);
        } else {
            this.sources.add(priority, source);
        }
    }

    @Override
    public T getData(NameInfo info) {
        T data = this.createData(info);
        boolean needDownload = true;
        for (DataProvider<T> source : this.sources) {
            Object dataFromSource = needDownload ? source.get(info) : null;
            if (dataFromSource == null) continue;
            needDownload = false;
            data = dataFromSource;
        }
        if (data.getStatus() == DownloadStatus.NOT_STARTED) {
            data.setStatus(DownloadStatus.IN_PROGRESS);
            this.store(info, data);
            this.getTextureProvidersManager().download(info);
        }
        return data;
    }

    @Override
    public void store(NameInfo info, T data) {
        this.sources.forEach(source -> source.store(info, data));
    }

    @Override
    public void invalidateData(NameInfo info) {
        this.sources.forEach(source -> source.invalidateData(info));
    }

    @Override
    @Nullable
    public DataProvider<T> getSource(String key) {
        return this.sources.stream().filter(source -> source.getName().equals(key)).findFirst().orElse(null);
    }

    @Override
    public HashMap<DataStoreKey, T> getGameData() {
        return this.sources.stream().map(source -> source).map(DataProvider::getAll).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, HashMap::new));
    }

    @Override
    public T findData(NameInfo info) {
        DataProvider<T> source = this.getSource("game");
        DataProvider<T> gameCache = source;
        if (gameCache != null) {
            return gameCache.get(info);
        }
        return null;
    }

    @Override
    public void delete(NameInfo info) {
        this.sources.forEach(source -> {
            if (source.delete(info)) {
                PlayerArmorStandsClient.LOGGER.info("Deleted data from source: {} for string: {}", (Object)source.getName(), (Object)info);
            }
        });
    }

    @Override
    public HashMap<String, DataProvider<T>> getSources() {
        return this.sources.stream().collect(Collectors.toMap(DataProvider::getName, source -> source, (a, b) -> b, HashMap::new));
    }

    protected abstract void prepareSources();

    protected abstract T createData(NameInfo var1);

    protected abstract TextureProvidersManager getTextureProvidersManager();
}

