/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.armorstand;

import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.impl.holder.CapeData;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.render.armorstand.PlayerArmorStandModel;
import com.danrus.pas.render.armorstand.RenderVersionContext;
import com.danrus.pas.utils.VersioningUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionfc;

public class ArmorStandCapeLayer
extends VersioningUtils.VersionlessArmorStandCapeLayer {
    public ArmorStandCapeLayer(VersioningUtils.VersionlessArmorStandCape parent) {
        super(parent);
    }

    @Override
    public void draw(PoseStack poseStack, RenderVersionContext context, NameInfo info, int light, boolean isBaby) {
        if (!info.wantCape()) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof PlayerArmorStandModel)) {
            return;
        }
        PlayerArmorStandModel model = (PlayerArmorStandModel)entityModel;
        CapeData capeData = PasManager.getInstance().getCapeDataManager().findData(info);
        if (capeData == null && (capeData = PasManager.getInstance().getCapeDataManager().getData(info)) != null && capeData.getStatus() == DownloadStatus.IN_PROGRESS) {
            return;
        }
        ResourceLocation capeTexture = PasManager.getInstance().getCapeWithOverlayTexture(info);
        if (capeTexture == null) {
            return;
        }
        if (PlayerArmorStandModel.showArmorStandWhileDownload(capeData)) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(10.0f));
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(180.0f));
        poseStack.translate(0.0f, 0.02f, -0.12f);
        if (isBaby) {
            poseStack.translate(0.0f, -0.02f, 0.21f);
        }
        context.getCape().draw(poseStack, capeTexture, context, light);
        poseStack.popPose();
    }
}

