/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.api.reg;

import com.danrus.pas.api.info.RenameFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class FeatureRegistry {
    private static final FeatureRegistry INSTANCE = new FeatureRegistry();
    private final Map<Class<? extends RenameFeature>, RenameFeature> prototypes = new ConcurrentHashMap<Class<? extends RenameFeature>, RenameFeature>();
    private final List<Class<? extends RenameFeature>> orderedFeatures = new ArrayList<Class<? extends RenameFeature>>();

    private FeatureRegistry() {
    }

    public static FeatureRegistry getInstance() {
        return INSTANCE;
    }

    public <T extends RenameFeature> void register(@NotNull Class<T> featureClass) {
        try {
            RenameFeature instance = (RenameFeature)featureClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.prototypes.put(featureClass, instance);
            this.orderedFeatures.add(featureClass);
            this.orderedFeatures.sort(Comparator.comparingInt(cls -> {
                try {
                    return ((RenameFeature)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getPriority();
                }
                catch (Exception e) {
                    return 100;
                }
            }));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Feature class must have a public no-arg constructor: " + featureClass.getName(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register feature: " + featureClass.getName(), e);
        }
    }

    public <T extends RenameFeature> T createFeature(@NotNull Class<T> featureClass) {
        try {
            return (T)((RenameFeature)featureClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Class<? extends RenameFeature>> getOrderedFeatures() {
        return Collections.unmodifiableList(this.orderedFeatures);
    }
}

