/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.features;

import com.danrus.pas.api.info.RenameFeature;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayNameFeature
implements RenameFeature {
    private static final String FLAG = "D:";
    private static final Pattern CLEANUP_PATTERN = Pattern.compile("D:[^|]+");
    boolean enabled = false;
    String name = "";

    @Override
    public boolean parse(@NotNull String input) {
        if (input.contains(FLAG)) {
            this.enabled = true;
            this.name = input.substring(input.indexOf(FLAG) + 2);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String compile() {
        if (!this.enabled) {
            return "";
        }
        return FLAG + this.name;
    }

    @Override
    @Nullable
    public Pattern getCleanupPattern() {
        return CLEANUP_PATTERN;
    }

    @Override
    public void reset() {
        this.enabled = false;
        this.name = "";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

