/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.api;

import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.NameInfo;
import com.danrus.pas.config.ModConfig;
import com.danrus.pas.utils.Rl;
import com.danrus.pas.utils.StringUtils;
import com.danrus.pas.utils.TextureUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class SkinData {
    public static ResourceLocation DEFAULT_TEXTURE = ModConfig.get().showArmorStandWhileDownloading ? Rl.vanilla("textures/entity/armorstand/wood.png") : Rl.vanilla("textures/entity/player/wide/steve.png");
    public static ResourceLocation DEFAULT_CAPE = Rl.pas("capes/cape.png");
    private String name;
    private List<TextureData> textures;
    private String params = "";
    private DownloadStatus status = DownloadStatus.NOT_STARTED;

    public SkinData(String name, String params) {
        this(name, DEFAULT_TEXTURE, DEFAULT_CAPE, params);
    }

    public SkinData(String name, ResourceLocation skinTexture, ResourceLocation capeTexture, String params) {
        this.name = name;
        this.params = params.toUpperCase();
        this.textures = List.of(new TextureData("skin", skinTexture), new TextureData("cape", capeTexture));
    }

    public SkinData(String playerName, ResourceLocation skinTexture, ResourceLocation capeTexture, DownloadStatus status) {
        this(playerName, skinTexture, capeTexture, "");
        this.status = status;
    }

    public SkinData(String playerName, ResourceLocation skinTexture, ResourceLocation capeTexture) {
        this(playerName, skinTexture, capeTexture, "");
    }

    public SkinData(String playerName) {
        this(playerName, DEFAULT_TEXTURE, DEFAULT_CAPE, "");
    }

    public SkinData(NameInfo info) {
        this(info.base(), DEFAULT_TEXTURE, DEFAULT_CAPE, info.params());
    }

    public SkinData(NameInfo info, ResourceLocation skinTexture, ResourceLocation capeTexture) {
        this(info.base(), skinTexture, capeTexture, info.params());
    }

    public SkinData(NameInfo info, ResourceLocation skinTexture) {
        this(info, skinTexture, DEFAULT_CAPE);
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTexture(String type) {
        if (type.isEmpty()) {
            return this.getDefaultTexture(type);
        }
        for (TextureData textureData : this.textures) {
            if (!textureData.type.equals(type)) continue;
            return textureData.texture;
        }
        return this.getDefaultTexture(type);
    }

    public ResourceLocation getDefaultTexture(String type) {
        return switch (type) {
            case "skin" -> DEFAULT_TEXTURE;
            case "cape" -> DEFAULT_CAPE;
            default -> MissingTextureAtlasSprite.getLocation();
        };
    }

    public ResourceLocation getSkinTexture(NameInfo info) {
        if (this.status != DownloadStatus.COMPLETED && this.status != DownloadStatus.NOT_STARTED) {
            return DEFAULT_TEXTURE;
        }
        if (!info.overlay().isEmpty()) {
            return TextureUtils.getOverlayTexture(info, info.overlay(), "skin", info.blend());
        }
        return this.getTexture("skin");
    }

    public ResourceLocation getCapeTexture(NameInfo info) {
        if (!info.overlay().isEmpty()) {
            return TextureUtils.getOverlayTexture(info, info.overlay(), "capes", info.blend());
        }
        return this.getTexture("cape");
    }

    public ResourceLocation getSkinTexture() {
        return this.getTexture("skin");
    }

    public ResourceLocation getCapeTexture() {
        return this.getTexture("cape");
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public String getParams() {
        return this.params;
    }

    public void setStatus(DownloadStatus status) {
        if (status != DownloadStatus.IMPOSSIBLE_TO_DOWNLOAD) {
            this.status = status;
        }
    }

    public void setSkinTexture(ResourceLocation skinTexture) {
        for (TextureData textureData : this.textures) {
            if (!textureData.type.equals("skin")) continue;
            textureData.texture = skinTexture;
            return;
        }
    }

    public void setCapeTexture(ResourceLocation capeTexture) {
        for (TextureData textureData : this.textures) {
            if (!textureData.type.equals("cape")) continue;
            textureData.texture = capeTexture;
            return;
        }
    }

    public void setParams(String params) {
        this.params = params.toUpperCase();
    }

    public void appendParams(String params) {
        if (params.contains("T") && this.params.contains("T")) {
            return;
        }
        if (params.contains("T")) {
            List<String> texureParams = StringUtils.matchTexture(params);
            if (texureParams.get(0).isEmpty()) {
                this.params = this.params + texureParams.get(2);
                return;
            }
            this.params = this.params + "T:" + texureParams.get(0) + texureParams.get(1) + texureParams.get(2);
            return;
        }
        if (this.params.isEmpty()) {
            this.params = params.toUpperCase();
        } else if (this.params.contains("T")) {
            this.params = params + this.params;
        }
    }

    static class TextureData {
        String type;
        ResourceLocation texture;

        public TextureData(String type, ResourceLocation texture) {
            this.type = type;
            this.texture = texture;
        }
    }
}

