/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.managers;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DataManager;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.SkinData;
import com.danrus.pas.api.TextureProvidersManager;
import com.danrus.pas.managers.SkinDataManager;
import com.danrus.pas.managers.SkinProvidersManager;
import com.danrus.pas.utils.TextureUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class PasManager {
    private static final PasManager INSTANCE = new PasManager();
    private SkinDataManager dataManager = new SkinDataManager();
    private SkinProvidersManager skinProviderManager = new SkinProvidersManager();
    private List<String> existingProviders = new ArrayList<String>(List.of("F"));
    private String currentName;
    private SkinData currentData;

    private PasManager() {
    }

    public ResourceLocation getSkinTexture(NameInfo info) {
        if (info.isEmpty()) {
            return SkinData.DEFAULT_TEXTURE;
        }
        if (info.overlay().isEmpty()) {
            return this.dataManager.getData(info).getSkinTexture();
        }
        return this.dataManager.getData(info).getSkinTexture(info);
    }

    public ResourceLocation getCapeTexture(NameInfo info) {
        if ("M".equals(info.capeProvider())) {
            return this.getData(info).getCapeTexture(info);
        }
        return null;
    }

    public SkinData getData(NameInfo info) {
        if (info.isEmpty()) {
            return new SkinData("default");
        }
        if (this.currentData != null && !this.currentName.isEmpty() && this.currentName.equals(info.base())) {
            return this.currentData;
        }
        this.currentName = info.base();
        this.currentData = this.dataManager.getData(info);
        return this.currentData;
    }

    public SkinData findData(NameInfo info) {
        if (info.isEmpty()) {
            return null;
        }
        return this.getDataManager().findData(info);
    }

    public void dropCache() {
        this.currentName = null;
        this.currentData = null;
        this.dataManager = new SkinDataManager();
        this.skinProviderManager = new SkinProvidersManager();
        this.existingProviders = new ArrayList<String>(List.of("F"));
        PlayerArmorStandsClient.LOGGER.info("SkinManger: Dropped all cached data");
    }

    public void reloadData(String string) {
        NameInfo info = NameInfo.parse(string);
        this.getDataManager().delete(info);
        TextureUtils.clearOverlayCacheFor(string);
        if (info.isEmpty()) {
            PlayerArmorStandsClient.LOGGER.warn("SkinManger: Cannot reload data for an empty name");
            return;
        }
        if (this.dataManager.getData(info) == null) {
            PlayerArmorStandsClient.LOGGER.warn("SkinManger: No data found for " + info.base() + ", reloading from providers");
            return;
        }
    }

    public void reloadFailed() {
        PlayerArmorStandsClient.LOGGER.info("SkinManger: Reloading failed skins");
        this.dataManager.getSources().forEach((key, source) -> source.getAll().forEach((dataKey, data) -> {
            if (data.getStatus() == DownloadStatus.FAILED) {
                PlayerArmorStandsClient.LOGGER.info("SkinManger: Reloading failed skin for " + dataKey);
                data.setStatus(DownloadStatus.NOT_STARTED);
                this.skinProviderManager.download(NameInfo.parse(dataKey));
            }
        }));
    }

    public static PasManager getInstance() {
        return INSTANCE;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public TextureProvidersManager getSkinProviderManager() {
        return this.skinProviderManager;
    }

    public List<String> getExistingProviders() {
        return List.copyOf(this.existingProviders);
    }
}

