/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.mixin;

import com.danrus.pas.api.NameInfo;
import com.danrus.pas.config.ModConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin {
    @Shadow
    @Final
    protected EntityRenderDispatcher entityRenderDispatcher;

    @Inject(method={"renderNameTag"}, at={@At(value="HEAD")}, cancellable=true)
    private <S extends EntityRenderState> void pas$renderNameTag(S renderState, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CallbackInfo ci) {
        Vec3 vec3;
        if (renderState instanceof ArmorStandRenderState && (vec3 = renderState.nameTagAttachment) != null) {
            NameInfo info = NameInfo.parse(((ArmorStandRenderState)renderState).customName);
            boolean bl = !renderState.isDiscrete;
            int i = "deadmau5".equals(info.base()) ? -10 : 0;
            poseStack.pushPose();
            poseStack.translate(vec3.x, vec3.y + 0.5, vec3.z);
            poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.last().pose();
            Font font = Minecraft.getInstance().font;
            if (displayName.getString().contains("|") && ModConfig.get().hideParamsOnLabel && ModConfig.get().enableMod) {
                displayName = Component.literal((String)info.base());
            }
            float f = (float)(-font.width((FormattedText)displayName)) / 2.0f;
            int j = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
            font.drawInBatch(displayName, f, (float)i, -2130706433, false, matrix4f, bufferSource, bl ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, packedLight);
            if (bl) {
                font.drawInBatch(displayName, f, (float)i, -1, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission((int)packedLight, (int)2));
            }
            poseStack.popPose();
            ci.cancel();
        }
    }
}

