/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.mixin;

import com.danrus.pas.api.NameInfo;
import com.danrus.pas.config.ModConfig;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.VersioningUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin<T extends LivingEntityRenderState, M extends EntityModel<T>> {
    @Inject(method={"getRenderType"}, at={@At(value="HEAD")}, cancellable=true)
    private void pas$renderType(LivingEntityRenderState entity, boolean b1, boolean b2, boolean b3, CallbackInfoReturnable<RenderType> cir) {
        if (!(entity instanceof ArmorStandRenderState) || !ModConfig.get().enableMod || VersioningUtils.isInvisible(entity)) {
            return;
        }
        if (VersioningUtils.getCustomName(entity) != null && ModConfig.get().enableMod) {
            cir.setReturnValue((Object)RenderType.entityTranslucent((ResourceLocation)PasManager.getInstance().getSkinTexture(NameInfo.parse(VersioningUtils.getCustomName(entity)))));
            cir.cancel();
        } else if (VersioningUtils.getCustomName(entity) == null && !ModConfig.get().defaultSkin.isEmpty()) {
            cir.setReturnValue((Object)RenderType.entityTranslucent((ResourceLocation)PasManager.getInstance().getSkinTexture(NameInfo.parse((Component)Component.literal((String)ModConfig.get().defaultSkin)))));
            cir.cancel();
        }
    }

    @Inject(method={"isEntityUpsideDown"}, at={@At(value="HEAD")}, cancellable=true)
    private static void pas$isEntityUpsideDown(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        if (!ModConfig.get().enableMod && !ModConfig.get().showEasterEggs || !(entity instanceof ArmorStand) || entity.getCustomName() == null) {
            return;
        }
        String name = NameInfo.parse(entity.getCustomName()).base();
        if ((name.equals("Dinnerbone") || name.equals("Grumm")) && entity instanceof ArmorStand) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }
}

