/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.armorstand;

import com.danrus.pas.api.NameInfo;
import com.danrus.pas.api.SkinData;
import com.danrus.pas.config.ModConfig;
import com.danrus.pas.render.armorstand.PlayerArmorStandModel;
import com.danrus.pas.utils.VersioningUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionfc;

public class ArmorStandCapeLayer
extends VersioningUtils.VersionlessArmorStandCapeLayer {
    public ArmorStandCapeLayer(VersioningUtils.VersionlessArmorStandCape parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorStandRenderState armorStand, float f1, float f2) {
        EntityModel entityModel;
        if (!ModConfig.get().enableMod || VersioningUtils.isInvisible(armorStand)) {
            return;
        }
        Component customName = VersioningUtils.getCustomName(armorStand);
        boolean isBaby = VersioningUtils.getIsBaby(armorStand);
        if (customName == null) {
            return;
        }
        NameInfo info = NameInfo.parse(VersioningUtils.getCustomName(armorStand));
        if (info.wantCape() && (entityModel = this.getParentModel()) instanceof PlayerArmorStandModel) {
            PlayerArmorStandModel model = (PlayerArmorStandModel)entityModel;
            SkinData skinData = model.getData();
            if (PlayerArmorStandModel.showArmorStandWhileDownload(customName, skinData)) {
                return;
            }
            ResourceLocation capeTexture = skinData.getCapeTexture(info);
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(10.0f));
            poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(180.0f));
            poseStack.translate(0.0f, 0.02f, -0.12f);
            if (isBaby) {
                poseStack.translate(0.0f, -0.02f, 0.21f);
            }
            model.getCape().visible = true;
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)capeTexture));
            model.getCape().render(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

