/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.NativeImage;
import java.nio.file.Path;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

public class VersioningUtils {
    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static boolean isModLoaded(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static Component getCustomName(Object object) {
        try {
            if (object instanceof ArmorStandRenderState) {
                ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
                return armorStandState.customName;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getNoBasePlate(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return !armorStandState.showBasePlate;
        }
        return false;
    }

    public static boolean getIsBaby(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.isBaby;
        }
        return false;
    }

    public static boolean getIsShowArms(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.showArms;
        }
        return false;
    }

    public static boolean isInvisible(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.isInvisible;
        }
        return false;
    }

    public static Rotations getHeadPose(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.headPose;
        }
        return new Rotations(0.0f, 0.0f, 0.0f);
    }

    public static Rotations getBodyPose(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.bodyPose;
        }
        return new Rotations(0.0f, 0.0f, 0.0f);
    }

    public static float getYRot(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.yRot;
        }
        return 0.0f;
    }

    public static int getPixel(NativeImage image, int x, int y) {
        return image.getPixel(x, y);
    }

    public static void setPixel(NativeImage image, int x, int y, int color) {
        image.setPixel(x, y, color);
    }

    public static float getXRot(Rotations rot) {
        return rot.x();
    }

    public static float getYRot(Rotations rot) {
        return rot.y();
    }

    public static float getZRot(Rotations rot) {
        return rot.z();
    }

    public static RenderPipeline getGuiRender() {
        return RenderPipelines.GUI_TEXTURED;
    }

    public static int getARGBwhite(float alpha) {
        return (int)Math.floor(alpha * 255.0f) << 24 | 0xFFFFFF;
    }

    public static ResourceLocation getPlayerSkinTexture(AbstractClientPlayer player) {
        return player.getSkin().texture();
    }

    public static ResourceLocation getPlayerCapeTexture(AbstractClientPlayer player) {
        return player.getSkin().capeTexture();
    }

    public static void copyPartPose(ModelPart from, ModelPart to) {
        to.copyFrom(from);
    }

    public static interface VersionlessArmorStandCape
    extends RenderLayerParent<ArmorStandRenderState, ArmorStandArmorModel> {
    }

    public static abstract class VersionlessArmorStandCapeLayer
    extends RenderLayer<ArmorStandRenderState, ArmorStandArmorModel> {
        public VersionlessArmorStandCapeLayer(RenderLayerParent<ArmorStandRenderState, ArmorStandArmorModel> renderer) {
            super(renderer);
        }
    }
}

