/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.data.common;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.data.DataProvider;
import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.data.DataStoreKey;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.api.reg.InfoTranslators;
import com.danrus.pas.utils.TextureUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractFileTextureDataProvider<T extends DataHolder>
implements DataProvider<T> {
    private final Map<DataStoreKey, T> cache = new HashMap<DataStoreKey, T>();

    @Override
    public T get(NameInfo info) {
        DataStoreKey key = this.getKey(info);
        if (this.cache.containsKey(key)) {
            return (T)((DataHolder)this.cache.get(key));
        }
        if (!info.getDesiredProvider().equals(this.getProviderCode())) {
            return null;
        }
        if (!this.isValidName(info.base())) {
            return null;
        }
        Path filePath = this.getFilePath(info);
        ResourceLocation textureLocation = InfoTranslators.getInstance().toResourceLocation(this.getDataHolderClass(), info);
        if (filePath.toFile().exists()) {
            Minecraft.getInstance().execute(() -> {
                TextureUtils.registerTexture(filePath, textureLocation, true);
                this.getDataManager().store(info, this.createDataHolder(info, textureLocation));
            });
        }
        T data = this.createDataHolder(info, textureLocation);
        data.setStatus(DownloadStatus.COMPLETED);
        this.getDataManager().store(info, data);
        return data;
    }

    @Override
    public T get(DataStoreKey key) {
        return (T)((DataHolder)this.cache.get(key));
    }

    private boolean isValidName(String name) {
        return name != null && !name.isEmpty() && name.length() <= 16 && name.matches("[a-zA-Z0-9_]+");
    }

    @Override
    public boolean delete(NameInfo info) {
        return true;
    }

    @Override
    public HashMap<DataStoreKey, T> getAll() {
        return new HashMap();
    }

    @Override
    public void store(NameInfo info, T data) {
    }

    @Override
    public void invalidateData(NameInfo info) {
        this.cache.remove(info.base());
    }

    private List<Path> getCacheFiles() {
        try {
            return List.of(this.getCachePath().toFile().listFiles()).stream().filter(file -> file.isFile() && file.getName().endsWith(".png")).map(file -> file.toPath()).toList();
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.error("Error listing cache files in " + String.valueOf(this.getCachePath()), (Throwable)e);
            return List.of();
        }
    }

    protected abstract Path getFilePath(NameInfo var1);

    protected abstract Path getCachePath();

    protected abstract T createDataHolder(NameInfo var1, ResourceLocation var2);

    protected abstract DataRepository<T> getDataManager();

    protected abstract String getProviderCode();

    protected abstract Class<? extends DataHolder> getDataHolderClass();

    protected abstract DataStoreKey getKey(NameInfo var1);
}

