/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.danrus.pas.ModExecutor;
import com.danrus.pas.utils.TextureUtils;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class SkinDownloader {
    public static CompletableFuture<ResourceLocation> downloadAndRegister(ResourceLocation texture, Path path, String uri, boolean remap) {
        return CompletableFuture.supplyAsync(() -> {
            NativeImage nativeImage;
            try {
                nativeImage = SkinDownloader.download(path, uri);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            return nativeImage;
        }, ModExecutor.DOWNLOAD_EXECUTOR).thenCompose(image -> TextureUtils.registerTexture(image, texture, remap));
    }

    private static NativeImage download(Path path, String uri) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                return nativeImage;
            }
        }
        int maxRetries = 3;
        int currentTry = 0;
        IOException lastException = null;
        while (currentTry < maxRetries) {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)URI.create(uri).toURL().openConnection(Minecraft.getInstance().getProxy());
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 Minecraft Client");
                connection.setConnectTimeout(15000);
                connection.setReadTimeout(15000);
                connection.setDoInput(true);
                connection.setDoOutput(false);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == 404) {
                    throw new IOException("Skin not found (404), uri: " + uri);
                }
                if (responseCode == 403) {
                    throw new IOException("Access to skin forbidden (403), uri: " + uri);
                }
                if (responseCode == 200) {
                    byte[] data = connection.getInputStream().readAllBytes();
                    try {
                        Files.write(path, data, new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    NativeImage nativeImage = NativeImage.read((byte[])data);
                    return nativeImage;
                }
                ++currentTry;
                Thread.sleep(1000L);
            }
            catch (IOException e) {
                lastException = e;
                ++currentTry;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Download interrupted", e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Download interrupted");
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
        throw new IOException("Failed to download after " + maxRetries + " attempts, uri: " + uri, lastException);
    }
}

