/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.config.ModConfig;
import com.danrus.pas.render.armorstand.PlayerArmorStandModel;
import com.danrus.pas.render.armorstand.RenderVersionContext;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

public class VersioningUtils {
    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static boolean isModLoaded(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static Component getCustomName(Object object) {
        try {
            if (object instanceof ArmorStandRenderState) {
                ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
                return armorStandState.customName;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getNoBasePlate(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return !armorStandState.showBasePlate;
        }
        return false;
    }

    public static boolean getIsBaby(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.isBaby;
        }
        return false;
    }

    public static boolean getIsShowArms(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.showArms;
        }
        return false;
    }

    public static boolean isInvisible(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.isInvisible;
        }
        return false;
    }

    public static Rotations getHeadPose(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.headPose;
        }
        return new Rotations(0.0f, 0.0f, 0.0f);
    }

    public static Rotations getBodyPose(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.bodyPose;
        }
        return new Rotations(0.0f, 0.0f, 0.0f);
    }

    public static float getYRot(Object object) {
        if (object instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandState = (ArmorStandRenderState)object;
            return armorStandState.yRot;
        }
        return 0.0f;
    }

    public static int getPixel(NativeImage image, int x, int y) {
        return image.getPixel(x, y);
    }

    public static void setPixel(NativeImage image, int x, int y, int color) {
        image.setPixel(x, y, color);
    }

    public static float getXRot(Rotations rot) {
        return rot.x();
    }

    public static float getYRot(Rotations rot) {
        return rot.y();
    }

    public static float getZRot(Rotations rot) {
        return rot.z();
    }

    public static Function<ResourceLocation, RenderType> getGuiRender() {
        return RenderType::guiTextured;
    }

    public static int getARGBwhite(float alpha) {
        return (int)Math.floor(alpha * 255.0f) << 24 | 0xFFFFFF;
    }

    public static ResourceLocation getPlayerSkinTexture(AbstractClientPlayer player) {
        return player.getSkin().texture();
    }

    public static ResourceLocation getPlayerCapeTexture(AbstractClientPlayer player) {
        return player.getSkin().capeTexture();
    }

    public static void copyPartPose(ModelPart from, ModelPart to) {
        to.copyFrom(from);
    }

    public static interface VersionlessArmorStandCape
    extends RenderLayerParent<ArmorStandRenderState, ArmorStandArmorModel> {
    }

    public static abstract class VersionlessArmorStandCapeLayer
    extends RenderLayer<ArmorStandRenderState, ArmorStandArmorModel> {
        public VersionlessArmorStandCapeLayer(RenderLayerParent<ArmorStandRenderState, ArmorStandArmorModel> renderer) {
            super(renderer);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorStandRenderState armorStand, float f1, float f2) {
            if (!ModConfig.get().enableMod || VersioningUtils.isInvisible(armorStand)) {
                return;
            }
            Component customName = VersioningUtils.getCustomName(armorStand);
            boolean isBaby = VersioningUtils.getIsBaby(armorStand);
            if (customName == null) {
                return;
            }
            NameInfo info = NameInfo.parse(customName);
            if (!info.wantCape()) {
                return;
            }
            EntityModel entityModel = this.getParentModel();
            if (!(entityModel instanceof PlayerArmorStandModel)) {
                return;
            }
            PlayerArmorStandModel model = (PlayerArmorStandModel)entityModel;
            RenderVersionContext context = new RenderVersionContext(model);
            context.putData(multiBufferSource, "multiBufferSource");
            this.draw(poseStack, context, info, i, isBaby);
        }

        protected abstract void draw(PoseStack var1, RenderVersionContext var2, NameInfo var3, int var4, boolean var5);
    }
}

