package com.danrus.mixin;

import com.danrus.PlayerArmorStands;
import com.danrus.utils.PASModelData;
import com.danrus.utils.StringUtils;
import com.danrus.utils.skin.SkinsUtils;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_922;
import net.minecraft.class_9998;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
        //?}


@Mixin(class_922.class)
public class LivingEntityRendererMixin /*? >=1.21.2 {*/ <T extends class_1309, S extends class_10042, M extends class_583<? super S>> /*} else {*//* <T extends LivingEntity> *//*?}*/{

    //? if >=1.21.2 {
    @Redirect(
            method = "render(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/LivingEntityRenderer;getRenderLayer(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;ZZZ)Lnet/minecraft/client/render/RenderLayer;")
    )
    private class_1921 getRenderLayerMixin(class_922 instance, S state, boolean showBody, boolean translucent, boolean showOutline) {
        if (state instanceof class_9998 armorStandEntityRenderState  && !armorStandEntityRenderState.field_53333) {
            if (armorStandEntityRenderState.field_53464 == null) return instance.method_24302(state, showBody, translucent, showOutline);
            PASModelData modelData = PlayerArmorStands.modelDataCache.get(StringUtils.matchASName(armorStandEntityRenderState.field_53464.getString()).getFirst());
            if (modelData == null) return instance.method_24302(state, showBody, translucent, showOutline);
            class_2960 identifier = modelData.texture;
            return class_1921.method_29379(identifier != null ? identifier : SkinsUtils.DEFAULT_TEXTURE);
        }
        return instance.method_24302(state, showBody, translucent, showOutline);
    }

    @Inject(
            method = "render(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at = @At("HEAD")
    )
    private void setModel(S livingEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        if (livingEntityRenderState instanceof class_9998) {
            if (livingEntityRenderState.field_53457) {
                ((class_922<T, S, M>) (Object) this).field_4737 = (M) PlayerArmorStands.smallModel;
            } else {
                ((class_922<T, S, M>) (Object) this).field_4737 = (M) PlayerArmorStands.model;
            }
        }
    }
    //?} else {
    /*@Redirect(
            method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/LivingEntityRenderer;getRenderLayer(Lnet/minecraft/entity/LivingEntity;ZZZ)Lnet/minecraft/client/render/RenderLayer;")
    )
    public RenderLayer getRenderLayerMixin(LivingEntityRenderer instance, LivingEntity livingEntity, boolean b1, boolean b2, boolean b3) {
        if (livingEntity instanceof ArmorStandEntity armorStandEntity && !armorStandEntity.isInvisible()) {
            if (armorStandEntity.getCustomName() == null) return instance.getRenderLayer(livingEntity, b1, b2, b3);
            PASModelData modelData = PlayerArmorStands.modelDataCache.get(StringUtils.matchASName(armorStandEntity.getCustomName().getString()).getFirst());
            if (modelData == null) return instance.getRenderLayer(livingEntity, b1, b2, b3);
            Identifier identifier = modelData.texture;
            return RenderLayer.getItemEntityTranslucentCull(identifier != null ? identifier : SkinsUtils.DEFAULT_TEXTURE);
        }
        return instance.getRenderLayer(livingEntity, b1, b2, b3);
    }
    *///?}
}
