/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.api.info.RenameFeature;
import com.danrus.pas.api.reg.FeatureRegistry;
import java.util.regex.Pattern;

public class NIParser {
    private static final NIParser instance = new NIParser();

    public NameInfo parse(String input) {
        if (input == null || input.isEmpty()) {
            return new NameInfo();
        }
        String[] divided = input.split("\\|", 2);
        String name = divided[0].trim();
        if (name.matches(".*[<>:\"/\\\\?*].*")) {
            return new NameInfo();
        }
        NameInfo info = new NameInfo(name);
        if (divided.length > 1) {
            String params = divided[1].trim();
            for (Class<? extends RenameFeature> featureClass : FeatureRegistry.getInstance().getOrderedFeatures()) {
                RenameFeature feature = info.getFeature(featureClass);
                if (feature == null || !feature.parse(params)) continue;
                String compiled = feature.compile();
                params = params.replace(compiled, "").trim();
            }
            info.legacyParams = NIParser.normalizeParams(params);
        }
        return info;
    }

    private static String normalizeParams(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        String p = raw.replaceAll("\\s+", "").toUpperCase();
        for (Class<? extends RenameFeature> featureClass : FeatureRegistry.getInstance().getOrderedFeatures()) {
            Pattern pattern;
            RenameFeature feature = FeatureRegistry.getInstance().createFeature(featureClass);
            if (feature == null || (pattern = feature.getCleanupPattern()) == null) continue;
            p = pattern.matcher(p).replaceAll("");
        }
        StringBuilder sb = new StringBuilder();
        boolean[] seen = new boolean[256];
        for (int i = 0; i < p.length(); ++i) {
            char ch = p.charAt(i);
            if (ch >= '\u0100' || seen[ch]) continue;
            seen[ch] = true;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static NIParser getInstance() {
        return instance;
    }
}

