package com.danrus.utils.skin;

import com.danrus.OverlayMessagesManager;
import com.danrus.PASExecutor;
import com.danrus.PlayerArmorStands;
import com.danrus.api.MojangApi;
import com.danrus.api.TextureHandler;
import com.danrus.utils.PASModelData;
import com.danrus.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9848;

public class PASSkinDownloader {
    public static void downloadSkin(String username, String source) {
        PASExecutor.execute(() -> {

            TextureHandler.getTextureURLS(username, source).thenApply(urls -> {

                if (urls == null || urls.isEmpty()) {
                    OverlayMessagesManager.doFailure(username, new Exception("No skin URLs found for: " + username));
                    return null;
                }

//                String filename = StringUtils.encodeToSha256(username);
                String filename = source == "namemc" ? username + "_namemc" : StringUtils.encodeToSha256(username);
                class_2960 id = class_2960.method_60655("pas", "skins/" + filename);

                downloadAndRegisterSkin(
                        id,
                        SkinsUtils.CACHE_DIR.resolve(filename + ".png"),
                        urls.get(0), true
                );

                String capeUrl = urls.size() > 1 ? urls.get(1) : null;
                if (capeUrl != null && !capeUrl.isEmpty()) {
                    class_2960 capeId = class_2960.method_60655("pas", "capes/" + filename);
                    downloadAndRegisterSkin(
                            capeId,
                            SkinsUtils.CACHE_DIR.resolve(filename + "_cape.png"),
                            capeUrl, false
                    ).thenAccept(
                            capeTextureId -> PASModelData.registerCape(username, capeTextureId)
                    );
                }

                class_310.method_1551().field_1705.method_1758(class_2561.method_43469("pas.download_success", username).method_27692(class_124.field_1060), false);
                PASModelData.registerCompleted(username, id);
                return null;
            });
        });
    }

    private static CompletableFuture<class_2960> downloadAndRegisterSkin(class_2960 textureId, Path path, String uri, boolean remap){
        return CompletableFuture.supplyAsync(() -> {
            class_1011 nativeImage;
            try {
                nativeImage = download(path, uri);
            } catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }

//            return /*? >=1.21.2 *//*remap ? remapTexture(nativeImage) :*//*} else {*/nativeImage/*?}*/;
//        }, Util.getDownloadWorkerExecutor()/*? >=1.21.2 *//*.named("downloadTexture")*//*?}*/).thenCompose((image) -> registerSkin(textureId, image));
            if (remap) {
                nativeImage = remapTexture(nativeImage);
            }
            return nativeImage;
        }, PASExecutor.DOWNLOAD_EXECUTOR).thenCompose((image) -> registerSkin(textureId, image));
    }
    private static class_1011 download(Path path, String uri) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {

            try (InputStream inputStream = Files.newInputStream(path)) {
                return class_1011.method_4309(inputStream);
            }
        } else {
            HttpURLConnection httpURLConnection = null;
            URI uRI = URI.create(uri);

            class_1011 iOException;
            try {
                httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection(class_310.method_1551().method_1487());
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(false);
                httpURLConnection.connect();
                int i = httpURLConnection.getResponseCode();
                if (i / 100 != 2) {
                    String var10002 = String.valueOf(uRI);
                    throw new IOException("Failed to open " + var10002 + ", HTTP error code: " + i);
                }

                byte[] bs = httpURLConnection.getInputStream().readAllBytes();

                try {
                    Files.write(path, bs, new OpenOption[0]);
                } catch (IOException var13) {
//                    LOGGER.warn("Failed to cache texture {} in {}", uri, path);
                }

                iOException = class_1011.method_49277(bs);
            } finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }

            }

            return iOException;
        }
    }

    private static CompletableFuture<class_2960> registerSkin(class_2960 textureId, class_1011 image) {
        class_310 minecraftClient = class_310.method_1551();
        return CompletableFuture.supplyAsync(() -> {
            //? <=1.21.4 {
            /*NativeImageBackedTexture texture = new NativeImageBackedTexture(image);
            *///?} else {
            class_1043 texture = new class_1043(textureId::toString, image);
            //?}
            minecraftClient.method_1531().method_4616(textureId, texture);
            return textureId;
        }, minecraftClient);
    }

    public static void registerSkin(Path skinPath, String name, class_2960 id) {
        try (InputStream inputStream = Files.newInputStream(skinPath)) {
            class_1011 image = remapTexture(class_1011.method_4309(inputStream));
//            NativeImage image = NativeImage.read(inputStream);
            //? <=1.21.4 {
            /*NativeImageBackedTexture texture = new NativeImageBackedTexture(image);
             *///?} else {
            class_1043 texture = new class_1043(id::toString, image);
            //?}
            class_310.method_1551().method_1531().method_4616(id, texture);
            PASModelData.registerCompleted(name, id);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerCape(Path capePath, String name, class_2960 id) {
        try (InputStream inputStream = Files.newInputStream(capePath)) {
            class_1011 image = class_1011.method_4309(inputStream);
            //? <=1.21.4 {
            /*NativeImageBackedTexture texture = new NativeImageBackedTexture(image);
             *///?} else {
            class_1043 texture = new class_1043(id::toString, image);
            //?}
            class_310.method_1551().method_1531().method_4616(id, texture);
            PASModelData.registerCape(name, id);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //? if >=1.21.2 {
    private static class_1011 remapTexture(class_1011 image) {
        int i = image.method_4323();
        int j = image.method_4307();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean bl = i == 32;
            if (bl) {
                class_1011 nativeImage = new class_1011(64, 64, true);
                nativeImage.method_4317(image);
                image.close();
                image = nativeImage;
                nativeImage.method_4326(0, 32, 64, 32, 0);
                nativeImage.method_4304(4, 16, 16, 32, 4, 4, true, false);
                nativeImage.method_4304(8, 16, 16, 32, 4, 4, true, false);
                nativeImage.method_4304(0, 20, 24, 32, 4, 12, true, false);
                nativeImage.method_4304(4, 20, 16, 32, 4, 12, true, false);
                nativeImage.method_4304(8, 20, 8, 32, 4, 12, true, false);
                nativeImage.method_4304(12, 20, 16, 32, 4, 12, true, false);
                nativeImage.method_4304(44, 16, -8, 32, 4, 4, true, false);
                nativeImage.method_4304(48, 16, -8, 32, 4, 4, true, false);
                nativeImage.method_4304(40, 20, 0, 32, 4, 12, true, false);
                nativeImage.method_4304(44, 20, -8, 32, 4, 12, true, false);
                nativeImage.method_4304(48, 20, -16, 32, 4, 12, true, false);
                nativeImage.method_4304(52, 20, -8, 32, 4, 12, true, false);
            }

            stripAlpha(image, 0, 0, 32, 16);
            if (bl) {
                stripColor(image, 32, 0, 64, 32);
            }

            stripAlpha(image, 0, 16, 64, 32);
            stripAlpha(image, 16, 48, 48, 64);
            return image;
        } else {
            image.close();
            throw new IllegalStateException("Discarding incorrectly sized (" + j + "x" + i + ") skin texture: " + image.toString());
        }
    }
    private static void stripColor(class_1011 image, int x1, int y1, int x2, int y2) {
        for(int i = x1; i < x2; ++i) {
            for(int j = y1; j < y2; ++j) {
                int k = image.method_61940(i, j);
                if (class_9848.method_61320(k) < 128) {
                    return;
                }
            }
        }

        for(int i = x1; i < x2; ++i) {
            for(int j = y1; j < y2; ++j) {
                image.method_61941(i, j, image.method_61940(i, j) & 16777215);
            }
        }

    }
    private static void stripAlpha(class_1011 image, int x1, int y1, int x2, int y2) {
        for(int i = x1; i < x2; ++i) {
            for(int j = y1; j < y2; ++j) {
                image.method_61941(i, j, class_9848.method_61334(image.method_61940(i, j)));
            }
        }

    }
    //?} else {
    /*private static NativeImage remapTexture(NativeImage image) {
        int i = image.getHeight();
        int j = image.getWidth();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean bl = i == 32;
            if (bl) {
                NativeImage nativeImage = new NativeImage(64, 64, true);
                nativeImage.copyFrom(image);
                image.close();
                image = nativeImage;
                nativeImage.fillRect(0, 32, 64, 32, 0);
                nativeImage.copyRect(4, 16, 16, 32, 4, 4, true, false);
                nativeImage.copyRect(8, 16, 16, 32, 4, 4, true, false);
                nativeImage.copyRect(0, 20, 24, 32, 4, 12, true, false);
                nativeImage.copyRect(4, 20, 16, 32, 4, 12, true, false);
                nativeImage.copyRect(8, 20, 8, 32, 4, 12, true, false);
                nativeImage.copyRect(12, 20, 16, 32, 4, 12, true, false);
                nativeImage.copyRect(44, 16, -8, 32, 4, 4, true, false);
                nativeImage.copyRect(48, 16, -8, 32, 4, 4, true, false);
                nativeImage.copyRect(40, 20, 0, 32, 4, 12, true, false);
                nativeImage.copyRect(44, 20, -8, 32, 4, 12, true, false);
                nativeImage.copyRect(48, 20, -16, 32, 4, 12, true, false);
                nativeImage.copyRect(52, 20, -8, 32, 4, 12, true, false);
            }

            stripAlpha(image, 0, 0, 32, 16);
            if (bl) {
                stripColor(image, 32, 0, 64, 32);
            }

            stripAlpha(image, 0, 16, 64, 32);
            stripAlpha(image, 16, 48, 48, 64);
            return image;
        } else {
            image.close();
            return null;
        }
    }

    private static void stripColor(NativeImage image, int x1, int y1, int x2, int y2) {
        for(int i = x1; i < x2; ++i) {
            for(int j = y1; j < y2; ++j) {
                int k = image.getColor(i, j);
                if ((k >> 24 & 255) < 128) {
                    return;
                }
            }
        }

        for(int i = x1; i < x2; ++i) {
            for(int j = y1; j < y2; ++j) {
                image.setColor(i, j, image.getColor(i, j) & 16777215);
            }
        }

    }

    private static void stripAlpha(NativeImage image, int x1, int y1, int x2, int y2) {
        for(int i = x1; i < x2; ++i) {
            for(int j = y1; j < y2; ++j) {
                image.setColor(i, j, image.getColor(i, j) | -16777216);
            }
        }

    }
    *///?}
}
