/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.api.reg;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.info.InfoTranslator;
import com.danrus.pas.api.info.NameInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2960;

public class InfoTranslators {
    private static final InfoTranslators INSTANCE = new InfoTranslators();
    private final HashMap<Class<? extends DataHolder>, List<InfoTranslator>> registry = new HashMap();

    public <T extends InfoTranslator> void register(Class<? extends DataHolder> clazz, T resolver) {
        this.registry.computeIfAbsent(clazz, k -> new ArrayList()).add(resolver);
    }

    public class_2960 toResourceLocation(Class<? extends DataHolder> type, NameInfo info) {
        List<InfoTranslator> list = this.registry.get(type);
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("No translators registered for type: " + String.valueOf(type));
        }
        for (InfoTranslator translator : list) {
            try {
                class_2960 location;
                if (!translator.isApplicable(info) || (location = translator.toResourceLocation(info)) == null) continue;
                return location;
            }
            catch (Exception e) {
                PlayerArmorStandsClient.LOGGER.warn("Translator {} failed for {}", new Object[]{translator.getClass().getSimpleName(), info, e});
            }
        }
        throw new IllegalArgumentException("No applicable InfoTransformer found for NameInfo: " + String.valueOf(info));
    }

    public String toFileName(Class<? extends DataHolder> type, NameInfo info) {
        List<InfoTranslator> list = this.registry.get(type);
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("No translators registered for type: " + String.valueOf(type));
        }
        for (InfoTranslator translator : list) {
            try {
                String fileName;
                if (!translator.isApplicable(info) || (fileName = translator.toFileName(info)) == null) continue;
                return fileName;
            }
            catch (Exception e) {
                PlayerArmorStandsClient.LOGGER.warn("Translator {} failed for {}", new Object[]{translator.getClass().getSimpleName(), info, e});
            }
        }
        if (!list.isEmpty()) {
            PlayerArmorStandsClient.LOGGER.warn("No applicable translator for {}, using fallback", (Object)info);
            return list.get(0).toFileName(info);
        }
        throw new IllegalArgumentException("No applicable InfoTransformer found for NameInfo: " + String.valueOf(info));
    }

    private InfoTranslators() {
    }

    public static InfoTranslators getInstance() {
        return INSTANCE;
    }
}

