/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.data.common;

import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.data.DataProvider;
import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.data.DataStoreKey;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.config.ModConfig;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClientLevelDataProvider<T extends DataHolder>
implements DataProvider<T> {
    @Override
    public T get(NameInfo info) {
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        if (!ModConfig.get().tryApplyFromServerPlayer) {
            return null;
        }
        T holder = this.createDataHolder(info);
        if (Minecraft.getInstance().level != null) {
            Minecraft.getInstance().level.players().stream().filter(player -> player.getName().getString().equals(info.base())).findFirst().ifPresent(player -> {
                if (this.getTexture((AbstractClientPlayer)player) != null) {
                    holder.setStatus(DownloadStatus.COMPLETED);
                    holder.setTexture(this.getTexture((AbstractClientPlayer)player));
                }
            });
        }
        if (holder.getStatus() == DownloadStatus.COMPLETED) {
            this.getDataManager().store(info, holder);
            return holder;
        }
        return null;
    }

    @Override
    public T get(DataStoreKey key) {
        return null;
    }

    @Override
    public boolean delete(NameInfo info) {
        return false;
    }

    @Override
    public HashMap<DataStoreKey, T> getAll() {
        if (Minecraft.getInstance().level == null) {
            return new HashMap();
        }
        return Minecraft.getInstance().level.players().stream().map(player -> {
            T data = this.createDataHolder(NameInfo.parse(player.getName().getString()));
            if (this.getTexture((AbstractClientPlayer)player) != null) {
                data.setStatus(DownloadStatus.COMPLETED);
                data.setTexture(this.getTexture((AbstractClientPlayer)player));
            }
            return data;
        }).collect(HashMap::new, (map, data) -> map.put(this.getKey(data.getInfo()), data), HashMap::putAll);
    }

    @Override
    public void store(NameInfo info, T data) {
    }

    @Override
    public void invalidateData(NameInfo info) {
    }

    @Override
    public String getName() {
        return "level";
    }

    @Nullable
    protected abstract ResourceLocation getTexture(AbstractClientPlayer var1);

    protected abstract T createDataHolder(NameInfo var1);

    protected abstract DataRepository<T> getDataManager();

    protected abstract DataStoreKey getKey(NameInfo var1);
}

