/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.data.common;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.data.DataProvider;
import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.data.DataStoreKey;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.api.reg.InfoTranslators;
import com.danrus.pas.utils.TextureUtils;
import com.danrus.pas.utils.VersioningUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractDiskDataProvider<T extends DataHolder>
implements DataProvider<T> {
    public static final Path CACHE_PATH = VersioningUtils.getGameDir().resolve("cache/pas");
    protected final Path cachePath;
    protected final HashMap<DataStoreKey, ResourceLocation> cache = new HashMap();

    public AbstractDiskDataProvider() {
        this.cachePath = CACHE_PATH;
        if (!this.cachePath.toFile().exists()) {
            this.cachePath.toFile().mkdirs();
        }
    }

    @Override
    public T get(NameInfo info) {
        if (this.getDataManager().findData(info) != null && this.getDataManager().findData(info).getStatus() == DownloadStatus.IMPOSSIBLE_TO_DOWNLOAD) {
            return null;
        }
        String fileName = InfoTranslators.getInstance().toFileName(this.getDataHolderClass(), info) + ".png";
        Path filePath = this.cachePath.resolve(fileName);
        if (!filePath.toFile().exists()) {
            return null;
        }
        ResourceLocation texture = InfoTranslators.getInstance().toResourceLocation(this.getDataHolderClass(), info);
        TextureUtils.registerTexture(filePath, texture, this.shouldProcessSkin());
        this.cache.put(this.getCacheKey(info), texture);
        T data = this.createDataHolder(info);
        data.setTexture(texture);
        data.setStatus(DownloadStatus.COMPLETED);
        this.getDataManager().store(info, data);
        return data;
    }

    @Override
    public T get(DataStoreKey key) {
        return null;
    }

    @Override
    public boolean delete(NameInfo info) {
        String fileName = InfoTranslators.getInstance().toFileName(this.getDataHolderClass(), info);
        Path filePath = this.cachePath.resolve(fileName);
        boolean deleted = false;
        if (filePath.toFile().exists()) {
            deleted = filePath.toFile().delete();
        }
        if (deleted) {
            this.cache.remove(this.getCacheKey(info));
        }
        return deleted;
    }

    @Override
    public HashMap<DataStoreKey, T> getAll() {
        return new HashMap();
    }

    @Override
    public void store(NameInfo info, T data) {
    }

    @Override
    public void invalidateData(NameInfo info) {
        String fileName = InfoTranslators.getInstance().toFileName(this.getDataHolderClass(), info);
        Path filePath = this.cachePath.resolve(fileName);
        if (filePath.toFile().exists()) {
            filePath.toFile().delete();
        }
        this.cache.remove(this.getCacheKey(info));
    }

    private List<Path> getCacheFiles() {
        try {
            return List.of(this.cachePath.toFile().listFiles()).stream().filter(file -> file.isFile() && file.getName().endsWith(".png")).map(file -> file.toPath()).toList();
        }
        catch (Exception e) {
            PlayerArmorStandsClient.LOGGER.error("Error listing cache files in " + String.valueOf(this.cachePath), (Throwable)e);
            return List.of();
        }
    }

    protected abstract T createDataHolder(NameInfo var1);

    protected abstract DataRepository<T> getDataManager();

    protected abstract Class<? extends DataHolder> getDataHolderClass();

    protected abstract boolean shouldProcessSkin();

    protected abstract DataStoreKey getCacheKey(NameInfo var1);
}

