/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.providers.common;

import com.danrus.pas.ModExecutor;
import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.data.TextureProvider;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.managers.OverlayMessageManger;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractNamemcProvider<T extends DataHolder>
implements TextureProvider {
    private String literal = "N";
    private Consumer<String> onComplete;
    private String output;

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public void load(NameInfo info, Consumer<String> onComplete) {
        this.onComplete = onComplete;
        this.output = this.getOutputString(info);
        this.initializeDownload(info);
        ModExecutor.execute(() -> ((CompletableFuture)this.getDownloadTask(info).thenApply(identifier -> {
            this.updateStatus(info, DownloadStatus.COMPLETED);
            this.updateSkinData(info, (ResourceLocation)identifier);
            onComplete.accept(this.output);
            OverlayMessageManger.getInstance().showSuccessMessage(info.base());
            return null;
        })).exceptionally(throwable -> {
            this.doFail(info);
            PlayerArmorStandsClient.LOGGER.error("NamemcProvider: Failed to download skin for " + String.valueOf(info), throwable);
            return null;
        }));
    }

    private void initializeDownload(NameInfo info) {
        PlayerArmorStandsClient.LOGGER.info("NamemcProvider: Downloading for " + String.valueOf(info));
        T data = this.createDataHolder(info);
        OverlayMessageManger.getInstance().showDownloadMessage(info.base());
        data.setStatus(DownloadStatus.IN_PROGRESS);
        this.getDataManager().store(info, data);
    }

    private void updateStatus(NameInfo info, DownloadStatus status) {
        T data = this.getOrCreateDataHolder(info);
        data.setStatus(status);
        this.getDataManager().store(info, data);
    }

    private void doFail(NameInfo info) {
        T data = this.getDataManager().getData(info);
        if (data == null) {
            data = this.createDataHolder(info);
        }
        OverlayMessageManger.getInstance().showFailMessage(info.base());
        data.setStatus(DownloadStatus.FAILED);
        this.getDataManager().store(info, data);
    }

    protected T getOrCreateDataHolder(NameInfo info) {
        T data = this.getDataFromNamemcRepository(info);
        return data != null ? data : this.createDataHolder(info);
    }

    protected abstract CompletableFuture<ResourceLocation> getDownloadTask(NameInfo var1);

    protected abstract DataRepository<T> getDataManager();

    protected abstract T createDataHolder(NameInfo var1);

    protected abstract void updateSkinData(NameInfo var1, ResourceLocation var2);

    protected abstract T getDataFromNamemcRepository(NameInfo var1);

    protected abstract String getOutputString(NameInfo var1);
}

