/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.gui.widgets;

import com.danrus.pas.utils.Rl;
import com.danrus.pas.utils.VersioningUtils;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class TextWidget
extends AbstractWidget {
    public static ResourceLocation QUESTION_MARK_ICON = Rl.pas("question");
    private boolean hasTooltip = false;

    public TextWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        Component component = this.getMessage();
        int n = this.getX() + this.getWidth() / 2 - (this.hasTooltip ? 4 : 0);
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawCenteredString(font, component, n, n2 + (n3 - 9) / 2, 0xFFFFFF | (int)(this.alpha * 255.0f) << 24);
        if (this.hasTooltip) {
            RenderPipeline renderPipeline = VersioningUtils.getGuiRender();
            int n4 = this.getX() + Minecraft.getInstance().font.width((FormattedText)this.getMessage()) / 3 + this.getWidth() / 2 + 13;
            int n5 = this.getY();
            int n6 = this.getHeight();
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.blitSprite(renderPipeline, QUESTION_MARK_ICON, n4, n5 + (n6 - 9) / 2 - 1, 9, 9);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }

    public TextWidget setTooltip(Component message) {
        Tooltip tooltip = Tooltip.create((Component)message);
        this.setTooltip(tooltip);
        this.hasTooltip = true;
        return this;
    }
}

