/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.features;

import com.danrus.pas.api.info.RenameFeature;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapeFeature
implements RenameFeature {
    private static final Pattern PARSE_PATTERN = Pattern.compile("C(?::([^%]+)%([^%|]+)%)?");
    private static final Pattern CLEANUP_PATTERN = Pattern.compile("C(?::[^%]+%[^%|]+%)?");
    private boolean enabled = false;
    private String provider = "M";
    private String id = "";

    @Override
    public boolean parse(@NotNull String input) {
        Matcher matcher = PARSE_PATTERN.matcher(input);
        if (matcher.find()) {
            this.enabled = true;
            String prov = matcher.group(1);
            String capeId = matcher.group(2);
            this.provider = prov != null ? prov.trim() : "M";
            this.id = capeId != null ? capeId.trim() : "";
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String compile() {
        if (!this.enabled) {
            return "";
        }
        StringBuilder sb = new StringBuilder("C");
        if (!this.id.isEmpty()) {
            sb.append(":").append(this.provider).append("%").append(this.id).append("%");
        }
        return sb.toString();
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void reset() {
        this.enabled = false;
        this.provider = "";
        this.id = "";
    }

    @Override
    @Nullable
    public Pattern getCleanupPattern() {
        return CLEANUP_PATTERN;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider == null ? "" : provider;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id == null ? "" : id;
    }
}

