/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.managers;

import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.data.TextureProvidersManager;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.impl.holder.CapeData;
import com.danrus.pas.impl.holder.SkinData;
import com.danrus.pas.managers.CapeDataRepository;
import com.danrus.pas.managers.CapeProvidersManager;
import com.danrus.pas.managers.SkinDataRepository;
import com.danrus.pas.managers.SkinProvidersManager;
import com.danrus.pas.utils.TextureUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasManager {
    private final Logger LOGGER = LoggerFactory.getLogger((String)"PasManager");
    private static PasManager INSTANCE;
    private SkinDataRepository skinDataRepository;
    private CapeDataRepository capeDataRepository;
    private SkinProvidersManager skinProviderManager;
    private CapeProvidersManager capeProviderManager;
    private List<String> existingProviders = new ArrayList<String>(List.of("F"));

    private PasManager() {
        this.skinDataRepository = new SkinDataRepository();
        this.capeDataRepository = new CapeDataRepository();
        this.skinProviderManager = new SkinProvidersManager();
        this.capeProviderManager = new CapeProvidersManager();
        this.skinProviderManager.initialize(this);
        this.capeProviderManager.initialize(this);
    }

    public ResourceLocation getSkinWithOverlayTexture(NameInfo info) {
        return TextureUtils.getOverlayedTexture(info, SkinData.class);
    }

    public ResourceLocation getCapeWithOverlayTexture(NameInfo info) {
        return TextureUtils.getOverlayedTexture(info, CapeData.class);
    }

    public ResourceLocation getSkinTexture(NameInfo info) {
        SkinData data = (SkinData)this.skinDataRepository.getData(info);
        return data != null ? data.getTexture(info) : null;
    }

    public ResourceLocation getCapeTexture(NameInfo info) {
        CapeData data = (CapeData)this.capeDataRepository.getData(info);
        return data != null ? data.getTexture(info) : null;
    }

    public SkinData findSkinData(NameInfo info) {
        if (info.isEmpty()) {
            return null;
        }
        return this.getSkinDataManager().findData(info);
    }

    public CapeData findCapeData(NameInfo info) {
        if (info.isEmpty()) {
            return null;
        }
        return this.getCapeDataManager().findData(info);
    }

    public void dropCache() {
        this.existingProviders = new ArrayList<String>(List.of("F"));
        this.skinDataRepository = new SkinDataRepository();
        this.capeDataRepository = new CapeDataRepository();
        this.skinProviderManager = new SkinProvidersManager();
        this.capeProviderManager = new CapeProvidersManager();
        this.skinProviderManager.initialize(this);
        this.capeProviderManager.initialize(this);
        PlayerArmorStandsClient.LOGGER.info("PasManager: Dropped all cached data");
    }

    public void reloadData(String string) {
        NameInfo info = NameInfo.parse(string);
        this.getSkinDataManager().delete(info);
        this.getCapeDataManager().delete(info);
        TextureUtils.clearOverlayCacheFor(string);
        if (info.isEmpty()) {
            this.LOGGER.warn("Cannot reload data for an empty name");
            return;
        }
        if (this.skinDataRepository.getData(info) == null) {
            this.LOGGER.warn("No data found for " + info.base() + ", reloading from skin providers");
            return;
        }
        if (this.capeDataRepository.getData(info) == null) {
            this.LOGGER.warn("No data found for " + info.base() + ", reloading from cape providers");
            return;
        }
    }

    public void reloadFailed() {
        this.LOGGER.info("Reloading failed textures");
        this.skinDataRepository.getSources().forEach((key, source) -> source.getAll().forEach((dataKey, data) -> {
            if (data.getStatus() == DownloadStatus.FAILED) {
                this.LOGGER.info("Reloading failed skin for " + String.valueOf(dataKey));
                data.setStatus(DownloadStatus.NOT_STARTED);
                NameInfo info = dataKey.toNameInfo();
                this.skinProviderManager.download(info);
            }
        }));
        this.capeDataRepository.getSources().forEach((key, source) -> source.getAll().forEach((dataKey, data) -> {
            if (data.getStatus() == DownloadStatus.FAILED) {
                this.LOGGER.info("Reloading failed cape for " + String.valueOf(dataKey));
                data.setStatus(DownloadStatus.NOT_STARTED);
                NameInfo info = dataKey.toNameInfo();
                this.capeProviderManager.download(info);
            }
        }));
    }

    public static PasManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PasManager();
        }
        return INSTANCE;
    }

    public DataRepository<SkinData> getSkinDataManager() {
        return this.skinDataRepository;
    }

    public DataRepository<CapeData> getCapeDataManager() {
        return this.capeDataRepository;
    }

    public TextureProvidersManager getSkinProviderManager() {
        return this.skinProviderManager;
    }

    public TextureProvidersManager getCapeProviderManager() {
        return this.capeProviderManager;
    }

    public List<String> getExistingProviders() {
        return this.existingProviders;
    }
}

