/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.armorstand;

import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.config.ModConfig;
import com.danrus.pas.impl.holder.CapeData;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.render.armorstand.PlayerArmorStandModel;
import com.danrus.pas.utils.VersioningUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorStandCapeLayer
extends VersioningUtils.VersionlessArmorStandCapeLayer {
    public ArmorStandCapeLayer(VersioningUtils.VersionlessArmorStandCape parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorStand armorStand, float f1, float f2, float f3, float f4, float f5, float f6) {
        if (!ModConfig.get().enableMod || VersioningUtils.isInvisible(armorStand)) {
            return;
        }
        Component customName = VersioningUtils.getCustomName(armorStand);
        boolean isBaby = VersioningUtils.getIsBaby(armorStand);
        if (customName == null) {
            return;
        }
        NameInfo info = NameInfo.parse(VersioningUtils.getCustomName(armorStand));
        if (!info.wantCape()) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof PlayerArmorStandModel)) {
            return;
        }
        PlayerArmorStandModel model = (PlayerArmorStandModel)entityModel;
        CapeData capeData = PasManager.getInstance().getCapeDataManager().findData(info);
        if (capeData == null && (capeData = PasManager.getInstance().getCapeDataManager().getData(info)) != null && capeData.getStatus() == DownloadStatus.IN_PROGRESS) {
            return;
        }
        if (PlayerArmorStandModel.showArmorStandWhileDownload(customName, capeData)) {
            return;
        }
        ResourceLocation capeTexture = PasManager.getInstance().getCapeWithOverlayTexture(info);
        if (capeTexture == null) {
            return;
        }
        if (PlayerArmorStandModel.showArmorStandWhileDownload(customName, capeData)) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(10.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        poseStack.translate(0.0f, 0.02f, -0.12f);
        if (isBaby) {
            poseStack.translate(0.0f, 0.71f, 0.21f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
        }
        model.getCape().visible = true;
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)capeTexture));
        model.getCape().render(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

