/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.render.gui;

import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.impl.data.skin.FileTextureSkinData;
import com.danrus.pas.impl.features.CapeFeature;
import com.danrus.pas.impl.features.DisplayNameFeature;
import com.danrus.pas.render.gui.ArmorStandNamerAdapter;
import com.danrus.pas.render.gui.tabs.Tab;
import com.danrus.pas.render.gui.tabs.TabManager;
import com.danrus.pas.render.gui.widgets.ButtonWithIcon;
import com.danrus.pas.render.gui.widgets.EnterEditBox;
import com.danrus.pas.render.gui.widgets.PasSliderButtonImpl;
import com.danrus.pas.render.gui.widgets.TabButton;
import com.danrus.pas.render.gui.widgets.TextWidget;
import com.danrus.pas.utils.Rl;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PasConfiguratorScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_TEXTURE = Rl.pas("pas_gui");
    public static final ResourceLocation MOJANG_LOGO = Rl.pas("mojang");
    public static final ResourceLocation NAMEMC_LOGO = Rl.pas("namemc");
    public static final ResourceLocation FILE_LOGO = Rl.pas("file");
    public static final ResourceLocation WIDE_ARM_LOGO = Rl.pas("wide");
    public static final ResourceLocation SLIM_ARM_LOGO = Rl.pas("slim");
    public static final ResourceLocation YES_LOGO = Rl.pas("yes");
    public static final ResourceLocation NO_LOGO = Rl.pas("no");
    private static final float ANIMATION_SPEED = 0.5f;
    private float currentRotation = 0.0f;
    private float targetRotation = 0.0f;
    private float currentHeadX = 0.0f;
    private float currentHeadY = 0.0f;
    private float currentHeadZ = 0.0f;
    private float targetHeadX = 0.0f;
    private float targetHeadY = 0.0f;
    private float targetHeadZ = 0.0f;
    private boolean isAnimating = false;
    private AnimationState currentAnimationState = AnimationState.IDLE;
    public final TabButton skinTabButton;
    public final TabButton capeTabButton;
    public final TabButton overlayTabButton;
    private final Button acceptButton;
    private final Button cancelButton;
    private final ArmorStand entity;
    private final ArmorStandNamerAdapter parent;
    private final ButtonWithIcon skinProviderButton;
    private final ButtonWithIcon armTypeButton;
    private final ButtonWithIcon armTypeButton2;
    private final TextWidget openFolderLabel;
    private final Button openFolderButton;
    private final ButtonWithIcon capeAciveButton;
    private final ButtonWithIcon capeProviderButton;
    private NameInfo info;
    private final TabManager tabManager;

    public PasConfiguratorScreen(ArmorStandNamerAdapter parent) {
        super((Component)Component.literal((String)"Player Armor Stand Configurator"));
        this.parent = parent;
        this.entity = new ArmorStand((Level)Minecraft.getInstance().level, 0.0, 0.0, 0.0);
        this.info = NameInfo.parse(parent.getNameInputValue());
        this.setEntityName(this.info.compile());
        this.acceptButton = Button.builder((Component)Component.translatable((String)"pas.menu.accept").withStyle(ChatFormatting.GREEN), b -> this.acceptName()).bounds(this.width, this.height / 2 - 110, 100, 20).build();
        this.cancelButton = Button.builder((Component)Component.translatable((String)"pas.menu.cancel").withStyle(ChatFormatting.RED), b -> Minecraft.getInstance().setScreen(parent.getScreen())).bounds(this.width, this.height / 2 + 110, 100, 20).build();
        this.skinTabButton = new TabButton(5, 5, 80, 15, (Component)Component.translatable((String)"pas.menu.tab.skin"));
        this.capeTabButton = new TabButton(105, 5, 80, 15, (Component)Component.translatable((String)"pas.menu.tab.cape"));
        this.overlayTabButton = new TabButton(205, 5, 80, 15, (Component)Component.translatable((String)"pas.menu.tab.overlay"));
        this.skinProviderButton = new ButtonWithIcon(0, 0, 120, 20, MOJANG_LOGO, (Component)Component.translatable((String)("pas.menu.tab.skin.provider." + this.info.getDesiredProvider().toLowerCase())), button -> this.changeSkinProvider(this.info.getDesiredProvider(), button));
        this.armTypeButton = new ButtonWithIcon(0, 0, 120, 20, this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO, (Component)Component.translatable((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))), button -> {
            this.info.setSlim(!this.info.wantBeSlim());
            ((ButtonWithIcon)button).icon = this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO;
            button.setMessage((Component)Component.translatable((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))));
            this.setEntityName(this.info.compile());
        });
        this.armTypeButton2 = new ButtonWithIcon(0, 0, 120, 20, this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO, (Component)Component.translatable((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))), button -> {
            this.info.setSlim(!this.info.wantBeSlim());
            ((ButtonWithIcon)button).icon = this.info.wantBeSlim() ? SLIM_ARM_LOGO : WIDE_ARM_LOGO;
            button.setMessage((Component)Component.translatable((String)("pas.menu.tab.skin.arm_type." + (this.info.wantBeSlim() ? "slim" : "wide"))));
            this.setEntityName(this.info.compile());
        });
        this.capeProviderButton = new ButtonWithIcon(0, 0, 120, 20, MOJANG_LOGO, (Component)Component.translatable((String)("pas.menu.tab.cape.provider." + this.info.getFeature(CapeFeature.class).getProvider().toLowerCase())), button -> {
            CapeFeature capeFeature = this.info.getFeature(CapeFeature.class);
            switch (capeFeature.getProvider()) {
                case "M": {
                    capeFeature.setProvider("A");
                    button.setMessage((Component)Component.translatable((String)"pas.menu.tab.cape.provider.a"));
                    break;
                }
                case "A": {
                    capeFeature.setProvider("M");
                    button.setMessage((Component)Component.translatable((String)"pas.menu.tab.cape.provider.m"));
                }
            }
            this.setEntityName(this.info.compile());
        });
        this.capeAciveButton = new ButtonWithIcon(0, 0, 120, 20, this.info.wantCape() ? YES_LOGO : NO_LOGO, (Component)(this.info.wantCape() ? Component.translatable((String)"pas.menu.tab.cape.yes") : Component.translatable((String)"pas.menu.tab.cape.no")), button -> {
            this.info.setCape(!this.info.wantCape());
            ((ButtonWithIcon)button).icon = this.info.wantCape() ? YES_LOGO : NO_LOGO;
            button.setMessage((Component)Component.translatable((String)("pas.menu.tab.cape." + (this.info.wantCape() ? "yes" : "no"))));
            this.setEntityName(this.info.compile());
        });
        this.openFolderLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.skin.open_folder"));
        this.openFolderButton = Button.builder((Component)Component.translatable((String)"pas.menu.tab.skin.open_folder.button"), button -> {
            FileTextureSkinData.SKINS_PATH.toFile().mkdirs();
            Util.getPlatform().openFile(FileTextureSkinData.SKINS_PATH.toFile());
        }).bounds(0, 0, 120, 20).build();
        this.tabManager = new TabManager(this);
        this.setupTabs();
    }

    private void setupTabs() {
        EnterEditBox nameBox = new EnterEditBox(Minecraft.getInstance().font, 0, 0, 100, 20, (Component)Component.literal((String)"Name"), editBox -> {
            this.info.setName(editBox.getValue());
            this.setEntityName(this.info.compile());
        });
        nameBox.setValue(this.info.base());
        TextWidget nameLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.skin.name")).setTooltip((Component)Component.translatable((String)"pas.menu.tab.skin.name.tooltip"));
        ImageButton acceptNameButton = new ImageButton(0, 0, 20, 20, new WidgetSprites(Rl.pas("accept"), Rl.pas("accept_disabled"), Rl.pas("accept_highlighted")), button -> {
            this.info.setName(nameBox.getValue());
            this.setEntityName(this.info.compile());
        });
        TextWidget skinProviderLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.skin.provider"));
        TextWidget armTypeLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.skin.arm_type"));
        Tab skinTab = new Tab("skin", (width, height) -> {
            nameLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 87.0f));
            nameBox.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            acceptNameButton.setPosition(Math.round((float)width.intValue() / 2.0f + 92.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            skinProviderLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            this.skinProviderButton.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            armTypeLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 10.0f));
            this.armTypeButton.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 10.0f));
            this.openFolderLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f + 30.0f));
            this.openFolderButton.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 50.0f));
        });
        skinTab.addWidget((AbstractWidget)nameBox);
        skinTab.addWidget(nameLabel);
        skinTab.addWidget((AbstractWidget)acceptNameButton);
        skinTab.addWidget(skinProviderLabel);
        skinTab.addWidget((AbstractWidget)this.skinProviderButton);
        skinTab.addWidget(armTypeLabel);
        skinTab.addWidget((AbstractWidget)this.armTypeButton);
        skinTab.addWidget(this.openFolderLabel);
        skinTab.addWidget((AbstractWidget)this.openFolderButton);
        TextWidget capeActiveLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.cape.label"));
        TextWidget capeProviderLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.cape.provider"));
        TextWidget capeNameLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.cape.name")).setTooltip((Component)Component.translatable((String)"pas.menu.tab.cape.name.tooltip"));
        TextWidget armTypeLabel2 = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.skin.arm_type"));
        EnterEditBox capeNameBox = new EnterEditBox(Minecraft.getInstance().font, 0, 0, 100, 20, (Component)Component.literal((String)"Cape Name"), editBox -> {
            CapeFeature capeFeature = this.info.getFeature(CapeFeature.class);
            capeFeature.setId(editBox.getValue());
            this.setEntityName(this.info.compile());
        });
        capeNameBox.setValue(this.info.getFeature(CapeFeature.class).getId());
        ImageButton acceptCapeButton = new ImageButton(0, 0, 20, 20, new WidgetSprites(Rl.pas("accept"), Rl.pas("accept_disabled"), Rl.pas("accept_highlighted")), button -> {
            this.info.getFeature(CapeFeature.class).setId(capeNameBox.getValue());
            this.setEntityName(this.info.compile());
        });
        Tab capeTab = new Tab("cape", (width, height) -> {
            capeActiveLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 87.0f));
            this.capeAciveButton.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            armTypeLabel2.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            this.armTypeButton2.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            capeProviderLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 10.0f));
            this.capeProviderButton.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 10.0f));
            capeNameLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f + 30.0f));
            capeNameBox.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 50.0f));
            armTypeLabel2.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            this.armTypeButton2.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            acceptCapeButton.setPosition(Math.round((float)width.intValue() / 2.0f + 92.0f), Math.round((float)height.intValue() / 2.0f + 50.0f));
        });
        capeTab.addWidget(capeActiveLabel);
        capeTab.addWidget((AbstractWidget)this.capeAciveButton);
        capeTab.addWidget(armTypeLabel2);
        capeTab.addWidget((AbstractWidget)this.armTypeButton2);
        capeTab.addWidget(capeProviderLabel);
        capeTab.addWidget((AbstractWidget)this.capeProviderButton);
        capeTab.addWidget(capeNameLabel);
        capeTab.addWidget((AbstractWidget)capeNameBox);
        capeTab.addWidget((AbstractWidget)acceptCapeButton);
        TextWidget blockTextureNameLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.overlay.name")).setTooltip((Component)Component.translatable((String)"pas.menu.tab.overlay.name.tooltip"));
        EnterEditBox blockTextureNameBox = new EnterEditBox(Minecraft.getInstance().font, 0, 0, 100, 20, (Component)Component.literal((String)"Overlay Name"), editBox -> {
            this.info.setOverlay(editBox.getValue());
            this.info.setBlend(Math.max(0, Math.min(100, this.info.blend())));
            this.setEntityName(this.info.compile());
        });
        PasSliderButtonImpl overlayBlendSlider = new PasSliderButtonImpl(0, 0, 120, 20, (Component)Component.literal((String)(this.info.blend() + "%")), this.info.blend(), i -> this.info.setBlend((int)i));
        ImageButton acceptOverlayNameButton = new ImageButton(0, 0, 20, 20, new WidgetSprites(Rl.pas("accept"), Rl.pas("accept_disabled"), Rl.pas("accept_highlighted")), button -> {
            this.info.setOverlay(blockTextureNameBox.getValue());
            this.info.setBlend(Math.max(0, Math.min(100, this.info.blend())));
            this.setEntityName(this.info.compile());
        });
        TextWidget displayNameLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.overlay.display_name")).setTooltip((Component)Component.translatable((String)"pas.menu.tab.overlay.display_name.tooltip"));
        EnterEditBox displayNameBox = new EnterEditBox(Minecraft.getInstance().font, 0, 0, 120, 20, (Component)Component.literal((String)"Display Name"), editBox -> {
            DisplayNameFeature feature = this.info.getFeature(DisplayNameFeature.class);
            if (feature != null) {
                feature.setEnabled(!editBox.getValue().isEmpty());
                feature.setName(editBox.getValue());
                this.setEntityName(this.info.compile());
            }
        });
        blockTextureNameBox.setValue(this.info.overlay());
        DisplayNameFeature displayNameFeature = this.info.getFeature(DisplayNameFeature.class);
        if (displayNameFeature != null && displayNameFeature.isEnabled()) {
            displayNameBox.setValue(displayNameFeature.getName());
        }
        TextWidget blockTextureBlendLabel = new TextWidget(0, 0, 100, 20, (Component)Component.translatable((String)"pas.menu.tab.overlay.blend"));
        Tab overlayTab = new Tab("overlay", (width, height) -> {
            blockTextureNameLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 87.0f));
            blockTextureNameBox.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            acceptOverlayNameButton.setPosition(Math.round((float)width.intValue() / 2.0f + 92.0f), Math.round((float)height.intValue() / 2.0f - 70.0f));
            blockTextureBlendLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 50.0f));
            overlayBlendSlider.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f - 30.0f));
            displayNameLabel.setPosition(Math.round((float)width.intValue() / 2.0f + 2.0f), Math.round((float)height.intValue() / 2.0f - 10.0f));
            displayNameBox.setPosition(Math.round((float)width.intValue() / 2.0f - 8.0f), Math.round((float)height.intValue() / 2.0f + 10.0f));
        });
        overlayTab.addWidget(blockTextureNameLabel);
        overlayTab.addWidget((AbstractWidget)blockTextureNameBox);
        overlayTab.addWidget((AbstractWidget)acceptOverlayNameButton);
        overlayTab.addWidget(blockTextureBlendLabel);
        overlayTab.addWidget((AbstractWidget)overlayBlendSlider);
        overlayTab.addWidget(displayNameLabel);
        overlayTab.addWidget((AbstractWidget)displayNameBox);
        this.tabManager.addTab(this.skinTabButton, skinTab);
        this.tabManager.addTab(this.capeTabButton, capeTab);
        this.tabManager.addTab(this.overlayTabButton, overlayTab);
    }

    protected void init() {
        this.tabManager.init();
        this.addRenderableWidget((GuiEventListener)this.acceptButton);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.repositionElements(this.width, this.height);
    }

    private void repositionElements(int width, int height) {
        this.addRenderableWidget((GuiEventListener)this.skinTabButton);
        this.addRenderableWidget((GuiEventListener)this.capeTabButton);
        this.addRenderableWidget((GuiEventListener)this.overlayTabButton);
        this.acceptButton.setPosition(width / 2 + 10, height / 2 + 120);
        this.cancelButton.setPosition(width / 2 - 110, height / 2 + 120);
        this.skinTabButton.setPosition(width / 2 - 124, height / 2 - 109);
        this.capeTabButton.setPosition(width / 2 - 43, height / 2 - 109);
        this.overlayTabButton.setPosition(width / 2 + 38, height / 2 - 109);
        this.tabManager.reposition(width, height);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.repositionElements(width, height);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(g, mouseX, mouseY, partialTick);
        g.blitSprite(BACKGROUND_TEXTURE, this.width / 2 - 128, this.height / 2 - 128 + 18, 256, 256);
    }

    public void tick() {
        boolean showOpenFolder;
        super.tick();
        this.currentAnimationState = this.tabManager.getActiveTab().getName().equals("cape") ? AnimationState.CAPE : AnimationState.IDLE;
        this.openFolderButton.visible = showOpenFolder = "F".equals(this.info.getDesiredProvider()) && this.tabManager.getActiveTab().getName().equals("skin");
        this.openFolderLabel.visible = showOpenFolder;
        this.openFolderButton.active = showOpenFolder;
        this.openFolderLabel.active = showOpenFolder;
        this.animateRotation(this.currentAnimationState);
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        super.render(g, mouseX, mouseY, partialTick);
        if (this.isAnimating) {
            this.currentRotation = this.lerp(this.currentRotation, this.targetRotation, 0.5f, partialTick);
            this.currentHeadX = this.lerp(this.currentHeadX, this.targetHeadX, 0.5f, partialTick);
            this.currentHeadY = this.lerp(this.currentHeadY, this.targetHeadY, 0.5f, partialTick);
            this.currentHeadZ = this.lerp(this.currentHeadZ, this.targetHeadZ, 0.5f, partialTick);
            if (Math.abs(this.currentRotation - this.targetRotation) < 0.01f) {
                this.isAnimating = false;
            }
        }
        if (this.info.getDesiredProvider().equals("M")) {
            this.skinProviderButton.icon = MOJANG_LOGO;
        } else if (this.info.getDesiredProvider().equals("N")) {
            this.skinProviderButton.icon = NAMEMC_LOGO;
        } else if (this.info.getDesiredProvider().equals("F")) {
            this.skinProviderButton.icon = FILE_LOGO;
        }
        if (this.info.getFeature(CapeFeature.class).getProvider().equals("M")) {
            this.capeProviderButton.icon = MOJANG_LOGO;
        } else if (this.info.getFeature(CapeFeature.class).getProvider().equals("A")) {
            this.capeProviderButton.icon = NAMEMC_LOGO;
        }
        g.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"pas.menu.name"), this.width / 2, 15, 0xFFFFFF);
        this.entity.setHeadPose(new Rotations(this.currentHeadX, this.currentHeadY, this.currentHeadZ));
        Quaternionf rotation = new Quaternionf().rotateX(3.4557521f).rotateY((float)Math.toRadians(this.currentRotation + 30.0f));
        InventoryScreen.renderEntityInInventory((GuiGraphics)g, (float)((int)((float)this.width / 2.0f - 68.0f)), (float)((int)((float)this.height / 2.0f + 80.0f)), (float)70.0f, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)rotation, null, (LivingEntity)this.entity);
    }

    private float lerp(float start, float end, float speed, float partialTick) {
        return start + (end - start) * speed * partialTick;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent.getScreen());
        this.acceptName();
    }

    private void setEntityName(String name) {
        if (name != null && !name.isEmpty()) {
            this.entity.setCustomName((Component)Component.literal((String)name));
        } else {
            this.entity.setCustomName(null);
        }
    }

    private void animateRotation(AnimationState state) {
        this.isAnimating = true;
        switch (state.ordinal()) {
            case 0: {
                this.targetRotation = 0.0f;
                this.targetHeadX = 0.0f;
                this.targetHeadY = 0.0f;
                this.targetHeadZ = 0.0f;
                break;
            }
            case 1: {
                this.targetRotation = 180.0f;
                this.targetHeadX = 10.0f;
                this.targetHeadY = -120.0f;
                this.targetHeadZ = 0.0f;
            }
        }
    }

    private void acceptName() {
        Minecraft.getInstance().setScreen(this.parent.getScreen());
        String toAnvil = this.info.compile();
        this.parent.setNameInputValue(toAnvil);
    }

    private void changeSkinProvider(String literal, Button button) {
        switch (literal) {
            case "M": {
                this.info.setProvider("N");
                button.setMessage((Component)Component.translatable((String)"pas.menu.tab.skin.provider.n"));
                break;
            }
            case "N": {
                this.info.setProvider("F");
                button.setMessage((Component)Component.translatable((String)"pas.menu.tab.skin.provider.f"));
                break;
            }
            case "F": {
                this.info.setProvider("M");
                button.setMessage((Component)Component.translatable((String)"pas.menu.tab.skin.provider.m"));
            }
        }
    }

    private static enum AnimationState {
        IDLE,
        CAPE;

    }
}

