/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.nio.file.Path;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

public class VersioningUtils {
    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static boolean isModLoaded(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static Component getCustomName(Object object) {
        try {
            if (object instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)object;
                return armorStand.getCustomName();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getNoBasePlate(Object object) {
        if (object instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)object;
            return armorStand.isNoBasePlate();
        }
        return false;
    }

    public static boolean getIsBaby(Object object) {
        if (object instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)object;
            return armorStand.isBaby();
        }
        return false;
    }

    public static boolean getIsShowArms(Object object) {
        if (object instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)object;
            return armorStand.isShowArms();
        }
        return false;
    }

    public static boolean isInvisible(Object object) {
        if (object instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)object;
            return armorStand.isInvisible();
        }
        return false;
    }

    public static Rotations getHeadPose(Object object) {
        if (object instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)object;
            return armorStand.getHeadPose();
        }
        return new Rotations(0.0f, 0.0f, 0.0f);
    }

    public static Rotations getBodyPose(Object object) {
        if (object instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)object;
            return armorStand.getBodyPose();
        }
        return new Rotations(0.0f, 0.0f, 0.0f);
    }

    public static float getYRot(Object object) {
        if (object instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)object;
            return armorStand.getYRot();
        }
        return 0.0f;
    }

    public static int getPixel(NativeImage image, int x, int y) {
        return image.getPixelRGBA(x, y);
    }

    public static void setPixel(NativeImage image, int x, int y, int color) {
        image.setPixelRGBA(x, y, color);
    }

    public static float getXRot(Rotations rot) {
        return rot.getX();
    }

    public static float getYRot(Rotations rot) {
        return rot.getY();
    }

    public static float getZRot(Rotations rot) {
        return rot.getZ();
    }

    public static int getARGBwhite(float alpha) {
        return (int)Math.floor(alpha * 255.0f) << 24 | 0xFFFFFF;
    }

    public static ResourceLocation getPlayerSkinTexture(AbstractClientPlayer player) {
        return player.getSkin().texture();
    }

    public static ResourceLocation getPlayerCapeTexture(AbstractClientPlayer player) {
        return player.getSkin().capeTexture();
    }

    public static void copyPartPose(ModelPart from, ModelPart to) {
        to.copyFrom(from);
    }

    public static interface VersionlessArmorStandCape
    extends RenderLayerParent<ArmorStand, ArmorStandArmorModel> {
    }

    public static abstract class VersionlessArmorStandCapeLayer
    extends RenderLayer<ArmorStand, ArmorStandArmorModel> {
        public VersionlessArmorStandCapeLayer(RenderLayerParent<ArmorStand, ArmorStandArmorModel> renderer) {
            super(renderer);
        }
    }
}

